% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markov.R
\name{markov}
\alias{markov}
\title{Fit a Markov model}
\usage{
markov(n0, n1, m, Time, Delta)
}
\arguments{
\item{n0}{The number of participants in the control arm.}

\item{n1}{The number of participants in the active treatment arm.}

\item{m}{The number of events in the hierarchy.}

\item{Time}{A \verb{m x (n0 + n1)} matrix of event times (days). Rows should represent events and columns should represent participants. Event
rows should be in increasing order of clinical severity.}

\item{Delta}{A \verb{m x (n0 + n1)} matrix of event indicators. Rows should represent events and columns should represent participants.
Event rows should be in increasing order of clinical severity.}
}
\value{
A list containing: a matrix of control arm state probabilities, a matrix of treatment arm state probabilities,
a vector of unique control arm event times (days), a vector of unique treatment arm event times (days), the number of unique control
arm event times, the number of unique treatment arm event times, the control arm max follow time (days), the treatment arm
max follow time (days), a matrix of combined arm state probabilities, a vector of unique combined arm event times (days),
the number of unique combined arm event times, the combined arm max follow time (days), a (m x m x number of combined arm event times)
matrix where (i,j,k)'th value is transition probability from state i to state j at k'th combined arm event time,
matrix where (i,j,k)'th value is transition probability from state i to state j at k'th trt arm event time,
matrix where (i,j,k)'th value is transition probability from state i to state j at k'th control arm event time.
}
\description{
This function fits an extended Markov model to calculate the state probabilities for each arm. In the wintime package, the returned state
probability distributions are used in all non-pairwise methods. The extended  Markov model is recommended for the Expected win time against
reference (EWTR) method and the EWTR-composite max test (MAX) method.
}
\examples{
# -----------------------------
# Example inputs
# -----------------------------

# Event time vectors
TIME_1 <- c(256,44,29,186,29,80,11,380,102,33)
TIME_2 <- c(128,44,95,186,69,66,153,380,117,33)
TIME_3 <- c(435,44,95,186,69,270,1063,380,117,33)

# Event time matrix
Time <- rbind(TIME_1, TIME_2, TIME_3)

# Event indicator vectors
DELTA_1 <- c(1,0,1,0,1,1,1,0,1,0)
DELTA_2 <- c(1,0,0,0,0,1,1,0,0,0)
DELTA_3 <- c(0,0,0,0,0,0,0,0,0,0)

# Event indicator matrix
Delta <- rbind(DELTA_1, DELTA_2, DELTA_3)

# Treatment arm indicator vector
trt <- c(1,1,1,1,1,0,0,0,0,0)

# Number of control arm patients
n0 <- sum(trt == 0)

# Number of treatment arm patients
n1 <- sum(trt == 1)

# Number of events in the hierarchy
m <- nrow(Time)

# -------------------------
# markov Examples
# -------------------------

z <- markov(n0, n1, m, Time, Delta)
print(z)

}
