% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pwt.R
\name{PWT}
\alias{PWT}
\title{Pairwise win time}
\usage{
PWT(n, n0, n1, m, Time, Delta, tg, tau)
}
\arguments{
\item{n}{The total number of trial participants.}

\item{n0}{The number of control arm patients.}

\item{n1}{The number of treatment arm patients.}

\item{m}{The number of events in the hierarchy.}

\item{Time}{A m x n matrix of event time (days). Rows should represent events and columns should represent participants. Event rows should
be in increasing order of clinical severity.}

\item{Delta}{A m x n matrix of event indicators. Rows should represent events and columns should represent participants. Event rows
should be in increasing order of clinical severity.}

\item{tg}{A numeric vector containing treatment arm indicators (1 for treatment, 0 for control).}

\item{tau}{The maximum follow up time (days).}
}
\value{
The pairwise win time, and the components of the pairwise win time.
}
\description{
This function calculates the sum of each pair's win time difference divided by the total number of pairs.
}
