% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incremental.R
\name{incremental_normalize}
\alias{incremental_normalize}
\title{Normalize incremental test data}
\usage{
incremental_normalize(
  .data,
  incremental_type = c("ramp", "step"),
  has_baseline = TRUE,
  baseline_length = NULL,
  work_rate_magic = FALSE,
  baseline_intensity = NULL,
  ramp_increase = NULL,
  step_start = NULL,
  step_increase = NULL,
  step_length = NULL,
  ...
)
}
\arguments{
\item{.data}{Data retrieved from \code{read_data()}.}

\item{incremental_type}{The type of the incremental test performed. Either "ramp" or "step".}

\item{has_baseline}{A boolean to indicate whether the data contains a baseline phase. This is used for an incremental test only. Default to \code{TRUE}.}

\item{baseline_length}{The baseline length (in seconds) performed.}

\item{work_rate_magic}{A boolean indicating whether to perform the work rate calculations. When set to \code{TRUE},
it will calculate the work rate throughout a ramp or step test. In the case of a step test, it will also
perform a linear transformation of the work rate.
If set to \code{TRUE}, the arguments below should be given. Default to \code{FALSE}.}

\item{baseline_intensity}{A numeric atomic vector indicating the work rate of the baseline. If the baseline was performed at rest, indicate \code{0}.}

\item{ramp_increase}{A numeric atomic vector indicating the ramp increase in watts per minute (W/min). For example, if the ramp
was \verb{30 W/min}, then pass the number \code{30} to this argument.}

\item{step_start}{In case your baseline was performed at rest, you can set in this parameter at which intensity
the step test started.}

\item{step_increase}{A numeric atomic vector indicating the step increase, in watts. For example, if the step increase was
\verb{25 W} at each step, then pass the number \code{25} to this argument.}

\item{step_length}{A numeric atomic vector indicating the length (in seconds) of each step in the step incremental test.}

\item{...}{Additional arguments. Currently ignored.}
}
\value{
a \link[tibble:tibble-package]{tibble}
}
\description{
Detect protocol phases (baseline, ramp, steps), normalize work rate, and
time-align baseline phase (baseline time becomes negative).
}
\examples{
\dontrun{
## get file path from example data
path_example <- system.file("ramp_cosmed.xlsx", package = "whippr")

## read data from ramp test
df <- read_data(path = path_example, metabolic_cart = "cosmed")

## normalize incremental test data
ramp_normalized <- df \%>\%
 incremental_normalize(
   .data = .,
   incremental_type = "ramp",
   has_baseline = TRUE,
   baseline_length = 240,
   work_rate_magic = TRUE,
   baseline_intensity = 20,
   ramp_increase = 25
 )

## get file path from example data
path_example_step <- system.file("step_cortex.xlsx", package = "whippr")

## read data from step test
df_step <- read_data(path = path_example_step, metabolic_cart = "cortex")

## normalize incremental test data
step_normalized <- df_step \%>\%
 incremental_normalize(
   .data = .,
   incremental_type = "step",
   has_baseline = TRUE,
   baseline_length = 120,
   work_rate_magic = TRUE,
   baseline_intensity = 0,
   step_start = 50,
   step_increase = 25,
   step_length = 180
 )
}
}
