% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{optimize_aisles}
\alias{optimize_aisles}
\title{Optimize Aisles for Warehouse Layout}
\usage{
optimize_aisles(arcs)
}
\arguments{
\item{arcs}{A data frame or matrix containing arc data, where each row represents an edge with columns such as `x_from`, `x_to`, `y_from`, `y_to`, and `distance`.}
}
\value{
A list containing the following elements:
- `changed`: A logical vector indicating which aisles were changed.
- `gain`: The gain in optimization for each aisle.
- `loss`: The loss for isolated aisles.
- `arcs_changed`: The updated arcs without the `id` column.
- `arcs_isolated`: The isolated arcs without the `id` column.
- `empty_aisles`: A vector of aisles that were found to be empty.
}
\description{
This internal function optimizes the aisles in a warehouse layout by finding the best cut points to reduce travel distances between arcs (edges).
}
\keyword{internal}
