% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_tto.R
\name{extract_tto}
\alias{extract_tto}
\title{Time to onset extraction}
\usage{
extract_tto(.data, adr_s, drug_s, tto_time_range = 1)
}
\arguments{
\item{.data}{A \code{link} data.table. See \code{\link{link_}}.}

\item{adr_s}{A character string. The name of the adr column. (see details)}

\item{drug_s}{A character string. The name of the drug column. (see details)}

\item{tto_time_range}{Incertitude range of Time to onset, in days. Defaults to 1 as recommended by umc}
}
\value{
A data.frame with
\itemize{
\item All available time to onsets for this combination (column \code{tto_max}).
\item \code{adr_s} and \code{drug_s}, same as input.
\item \code{UMCReportId}, the unique identifier of the case.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}} \code{extract_tto()} collects
all available time to onsets for a set of drug-adr pairs.
}
\details{
Extraction of (maximum available) time between drug initiation
and event onset. This runs at the drug-adr pair level.
You will need a \code{link} data.table, see \code{\link{link_}}, on which
you have added drugs and adrs with \code{\link[=add_drug]{add_drug()}} and \code{\link[=add_adr]{add_adr()}}.
Uppsala Monitoring Centre recommends to use only cases where the incertitude
on time to onset is less than \strong{1 day}. You can change this with \code{tto_time_range}.
You might want to use \code{\link[=desc_tto]{desc_tto()}} to obtain summary statistics of
time to onset, but \code{extract_tto()} is useful to get the raw data and plot it,
for instance with \code{ggplot2}.
}
\examples{
link_ <-
  link_ |>
  add_drug(
    d_code = ex_$d_groups_drecno,
    drug_data = drug_
  ) |>
  add_adr(
    a_code = ex_$a_llt,
    adr_data = adr_
  )

extract_tto(.data = link_,
         adr_s = "a_colitis",
         drug_s = "pd1")
extract_tto(.data = link_,
         adr_s = c("a_colitis", "a_pneumonitis"),
         drug_s = c("pd1", "ctla4"))
}
\seealso{
\code{\link{link_}}, \code{\link[=desc_tto]{desc_tto()}}, \code{\link[=add_drug]{add_drug()}}, \code{\link[=add_adr]{add_adr()}}, \code{\link[=desc_dch]{desc_dch()}}, \code{\link[=desc_rch]{desc_rch()}}
}
\keyword{descriptive}
\keyword{drug-adr-pair}
