% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxa2samples.R
\name{taxa2samples}
\alias{taxa2samples}
\alias{taxa2samples.vegtable}
\alias{taxa2samples,vegtable-method}
\title{Insert taxon information into samples}
\usage{
taxa2samples(object, ...)

\method{taxa2samples}{vegtable}(
  object,
  merge_to,
  include_levels,
  add_relations = FALSE,
  add_traits = FALSE,
  ...
)
}
\arguments{
\item{object}{A \linkS4class{vegtable} object.}

\item{...}{Further arguments passed among methods.}

\item{merge_to}{Character value indicating the level (taxonomic rank) to
which taxa of lower rank have to be merged.}

\item{include_levels}{Character vector indicating the levels to be considered
in the output object. This will set the values of \strong{TaxonConceptID} and
any respective values inserted from slots \strong{taxonRelations} and
\strong{taxonTraits} as NA.}

\item{add_relations}{A logical value indicating whether the content of slot
\strong{taxonRelations} have to be inserted in slot \strong{samples} or not.}

\item{add_traits}{A logical value indicating whether the content of slot
\strong{taxonTraits} have to be inserted in slot \strong{samples} or not.}
}
\value{
An object of class \linkS4class{vegtable}.
}
\description{
For statistical purposes it may be necessary to insert information on
recorded taxa into the slot samples, which contain the records of taxa in
sampling plots.
This can be also done selectivelly for specific taxonomic ranks and lower
ranks can be aggregated to their parental ones.

If column \strong{TaxonConceptID} is already existing in \code{'objec@samples'},
this column will get overwritten, retrieving a warning message.
}
\examples{
## Add only variable TaxonConceptID
veg <- taxa2samples(Kenya_veg)
head(veg@samples)

## Add also information from slots taxonRelations and taxonTraits
veg <- taxa2samples(Kenya_veg, add_relations = TRUE, add_traits = TRUE)
head(veg@samples)

## Different ranks recorded at samples
veg <- taxa2samples(Kenya_veg, add_relations = TRUE)
summary(veg@samples$Level)

## Aggregate taxa to family level
veg <- taxa2samples(Kenya_veg, add_relations = TRUE, merge_to = "family")
summary(veg@samples$Level)

}
\author{
Miguel Alvarez \email{kamapu78@gmail.com}
}
