% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_rep.R
\name{replicate.prop1}
\alias{replicate.prop1}
\title{Compares and combines single proportion in original and follow-up studies}
\usage{
replicate.prop1(alpha, f1, n1, f2, n2)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{f1}{frequency count in original study}

\item{n1}{sample size in original study}

\item{f2}{frequency count in follow-up study}

\item{n2}{sample size for in follow-up study}
}
\value{
A 4-row matrix. The rows are:
\itemize{
\item Row 1 summarizes the original study
\item Row 2 summarizes the follow-up study
\item Row 3 estimates the difference in proportions
\item Row 4 estimates the average proportion
}

The columns are:
\itemize{
\item Estimate - proportion estimate (single study, difference, average)
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
This function computes confidence intervals for a single proportion from an
original study and a follow-up study. Confidence intervals for the
difference between the two proportions and average of the two proportions
are also computed. The confidence level for the difference is 1 – 2*alpha,
which is recommended for equivalence testing.
}
\examples{
replicate.prop1(.05, 21, 300, 35, 400)

# Should return:
#                          Estimate         SE          LL         UL
# Original:              0.07565789 0.01516725  0.04593064 0.10538515
# Follow-up:             0.09158416 0.01435033  0.06345803 0.11971029
# Original - Follow-up: -0.01670456 0.02065098 -0.05067239 0.01726328
# Average:               0.08119996 0.01032549  0.06096237 0.10143755


}
\references{
\insertRef{Bonett2021}{vcmeta}
}
