% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_comp.R
\name{meta.sub.cor}
\alias{meta.sub.cor}
\title{Confidence interval for a subgroup difference in average Pearson
or partial correlations}
\usage{
meta.sub.cor(alpha, n, cor, s, group)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{n}{vector of sample sizes}

\item{cor}{vector of estimated correlations}

\item{s}{number of control variables (set to 0 for Pearson)}

\item{group}{vector of group indicators:
\itemize{
\item 1 for set A
\item 2 for set B
\item 0 to ignore
}}
}
\value{
Returns a matrix with three rows:
\itemize{
\item Row 1 - estimate for Set A
\item Row 2 - estimate for Set B
\item Row 3 - estimate for difference, Set A - Set B
}

The columns are:
\itemize{
\item Estimate - estimated average correlation or difference
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes the estimate, standard error, and confidence interval for a
difference in average Pearson or partial correlations for two mutually
exclusive subgroups of studies. Each subgroup can have one or more
studies. All of the correlations must be either Pearson correlations
or partial correlations.
}
\examples{
n <- c(55, 190, 65, 35)
cor <- c(.40, .65, .60, .45)
group <- c(1, 1, 2, 0)
meta.sub.cor(.05, n, cor, 0, group)

# Should return:
#                Estimate         SE         LL        UL
# Set A:            0.525 0.06195298  0.3932082 0.6356531
# Set B:            0.600 0.08128008  0.4171458 0.7361686
# Set A - Set B:   -0.075 0.10219894 -0.2645019 0.1387283


}
\references{
\insertRef{Bonett2008a}{vcmeta}
}
