% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theorical_comparison.R
\name{compute_utility_stats}
\alias{compute_utility_stats}
\title{compute_utility_stats}
\usage{
compute_utility_stats(
  value_sets_3L = NULL,
  value_sets_5L = NULL,
  value_sets_XW = NULL,
  value_sets_XWR = NULL,
  value_sets_others = NULL,
  format_results = FALSE
)
}
\arguments{
\item{value_sets_3L}{(Optional) A character vector specifying the country value sets for EQ5D-3L version.}

\item{value_sets_5L}{(Optional) A character vector specifying the country value sets for EQ5D-5L version.}

\item{value_sets_XW}{(Optional) A character vector specifying the country value sets for EQ5D-XW version.}

\item{value_sets_XWR}{(Optional) A character vector specifying the country value sets for EQ5D-XWR version.}

\item{value_sets_others}{(Optional) A list of lists specifying the inputs for other instruments. Each list within the main list should be named and contain a data frame (`df`), a column specifying the health states (`stateColumn`), and a column specifying the utility values (`utilityColumn`).}

\item{format_results}{(Optional) A logical indicating whether the result should be formatted. Default is FALSE.}
}
\value{
A data frame containing utility statistics for each provided value set.
}
\description{
Compute utility statistics for given EQ5D versions and value sets.
}
\note{
Mean single level transitions are calculated only for EQ-5D.
}
\examples{
compute_utility_stats(value_sets_3L = "ES", value_sets_5L = "ES")
value_set_other <- list(instrument1 = list(df = data.frame(state=c(1, 2, 3), utility = c(-1, 0, 1)), 
                        stateColumn = "state", 
                        utilityColumn = "utility"))
compute_utility_stats(value_sets_3L = "AR", value_sets_others = value_set_other)
}
