% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{usrivers}
\alias{usrivers}
\title{US Major Rivers (2010)}
\format{
A simple features (sf) data frame with 55 rows and 5 variables.
}
\usage{
data(usrivers)
}
\description{
Major rivers in the United States.\cr\cr
The data is can be transformed with \code{\link[=usmap_transform]{usmap_transform()}}.
Once the \code{Shape} strings are transformed, it can be added to
\code{\link[=plot_usmap]{plot_usmap()}} using a \code{\link[ggplot2:ggsf]{ggplot2::geom_sf()}} layer.
}
\details{
\itemize{
\item \code{NAME} The name of the river.
\item \code{SYSTEM} The system the river belongs to.
\item \code{MILES} The length of the river in miles.
\item \code{Shape_Length} The length of the river in the coordinate system.
\item \code{Shape} The MULTILINESTRING features depicting the river, for plotting.
}
}
\references{
\itemize{
\item \url{https://www.arcgis.com/home/item.html?id=290e4ab8a07f4d2c8392848d011add32#!}
\item Sources: Esri; Rand McNally; Bartholemew and Times Books;
Digital Chart of the World (DCW), U.S. National Geospatial-Intelligence Agency (NGA); i-cubed
}
}
\keyword{data}
