% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UMass.R
\docType{data}
\name{umass_neutrals}
\alias{umass_neutrals}
\title{Neutral colors of the University of Massachusetts Amherst, USA}
\format{
An object of class \code{character} of length 3.
}
\source{
Color definitions are based on the \href{https://www.umass.edu}{UMass} 
\href{https://www.umass.edu/university-relations/brand/brand-elements#color}{Brand guide}.
}
\usage{
umass_neutrals
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{umass_neutrals} provides the three neutral colors 
of the \href{https://www.umass.edu}{University of Massachusetts Amherst}, USA.
}
\details{
The 3 neutral colors are
\code{"PMS 447"} (defined as C50 M30 Y40 K90, R55 G58 B54, HEX 373a36), 
\code{"PMS 445"} (defined as C52 M23 Y30 K74, R80 G87 B89, HEX 505759), and
\code{"PMS 429"} (defined as C21 M11 Y9 K23, R162 G170 B173, HEX a2aaad).

\code{umass_neutrals} uses the HEX color definitions.
}
\examples{
umass_neutrals
unikn::seecol(umass_neutrals, main = "Neutral colors of UMass")  # view palette

}
\seealso{
\code{\link{umass_1}} for brand colors of UMass;
\code{\link{umass_2}} for secondary colors of UMass;
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other U.S. university color palettes: 
\code{\link{asu_1}},
\code{\link{asu_2}},
\code{\link{asu_3}},
\code{\link{berkeley_1}},
\code{\link{berkeley_2}},
\code{\link{brown_1}},
\code{\link{brown_2}},
\code{\link{bu}},
\code{\link{caltech_1}},
\code{\link{caltech_2}},
\code{\link{caltech_3}},
\code{\link{cmu_1}},
\code{\link{cmu_2}},
\code{\link{cmu_3}},
\code{\link{columbia_1}},
\code{\link{columbia_2}},
\code{\link{columbia_3}},
\code{\link{cornell_1}},
\code{\link{cornell_2}},
\code{\link{cornell_3_accent}},
\code{\link{dartmouth_1}},
\code{\link{dartmouth_2}},
\code{\link{dartmouth_3}},
\code{\link{duke_1}},
\code{\link{duke_2}},
\code{\link{harvard_1}},
\code{\link{harvard_2}},
\code{\link{harvard_3}},
\code{\link{jhu_0}},
\code{\link{jhu_1}},
\code{\link{jhu_2}},
\code{\link{jhu_3_accent}},
\code{\link{jhu_4_gray}},
\code{\link{manchester_uni_1}},
\code{\link{manchester_uni_2}},
\code{\link{michigan_1}},
\code{\link{michigan_2}},
\code{\link{minnesotatwin_1}},
\code{\link{minnesotatwin_2}},
\code{\link{mit}},
\code{\link{monash_1}},
\code{\link{monash_2}},
\code{\link{msu}},
\code{\link{northwestern_1}},
\code{\link{northwestern_2}},
\code{\link{notredame_1}},
\code{\link{notredame_2}},
\code{\link{nyu_1}},
\code{\link{nyu_2}},
\code{\link{nyu_accent}},
\code{\link{nyu_neutral}},
\code{\link{ohio_uni_1}},
\code{\link{ohio_uni_2}},
\code{\link{pitt_1}},
\code{\link{pitt_2}},
\code{\link{princeton_0}},
\code{\link{princeton_1}},
\code{\link{princeton_2}},
\code{\link{rpi_1}},
\code{\link{rpi_2}},
\code{\link{rpi_3}},
\code{\link{stanford_1}},
\code{\link{stanford_2}},
\code{\link{stanford_3}},
\code{\link{uchicago_1}},
\code{\link{uchicago_2}},
\code{\link{uci_1}},
\code{\link{uci_2}},
\code{\link{uci_3}},
\code{\link{uci_4}},
\code{\link{ucla_1}},
\code{\link{ucla_2}},
\code{\link{ucla_3}},
\code{\link{ucla_4}},
\code{\link{ucsd_1}},
\code{\link{ucsd_2}},
\code{\link{ucsd_3}},
\code{\link{uflorida_1}},
\code{\link{uflorida_2}},
\code{\link{uflorida_3}},
\code{\link{umass_1}},
\code{\link{umass_2}},
\code{\link{upenn_1}},
\code{\link{upenn_2}},
\code{\link{vanderbilt_1}},
\code{\link{vanderbilt_2}},
\code{\link{vanderbilt_3}},
\code{\link{willamette}},
\code{\link{wm_1}},
\code{\link{wm_2}},
\code{\link{wm_3}},
\code{\link{yale}},
\code{\link{yeshiva}}
}
\author{
\strong{unicol}, 2023-06-27.
}
\concept{U.S. university color palettes}
\keyword{datasets}
