% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Stockholm.R
\docType{data}
\name{stockholm_1}
\alias{stockholm_1}
\title{Main colours of the University of Stockholm, Sweden}
\format{
An object of class \code{character} of length 5.
}
\source{
Color definitions are based on 
\href{https://www.su.se}{SU's} 
\href{https://www.su.se/staff/organisation-governance/governing-documents-rules-and-regulations/communication-collaboration/rules-for-the-visual-identity-at-stockholm-university-1.17458}{visual identity guide} (HTML).
}
\usage{
stockholm_1
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{stockholm_1} provides the primary and four secondary colours  
of the \href{https://www.su.se}{University of Stockholm}, Sweden.
}
\details{
\code{stockholm_1} is based on the digital palette and uses HEX color definitions. 
(See the \href{https://www.su.se/staff/organisation-governance/governing-documents-rules-and-regulations/communication-collaboration/rules-for-the-visual-identity-at-stockholm-university-1.17458}{visual identity guide} 
for printing details and definitions.)
}
\examples{
stockholm_1
unikn::seecol(stockholm_1, 
              main = "Main colours of the University of Stockholm, Sweden")  # view palette

}
\seealso{
\code{\link{stockholm_2}} for additional colours of the University of Stockholm;
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other Swedish university color palettes: 
\code{\link{gothenburg}},
\code{\link{lund_1}},
\code{\link{lund_2}},
\code{\link{lund_3}},
\code{\link{stockholm_2}},
\code{\link{uppsala}}
}
\author{
\strong{unicol}, 2023-10-12.
}
\concept{Swedish university color palettes}
\keyword{datasets}
