## Nottingham.R | 2023 09 04
## Colors of the University of Nottingham, England/UK
## --------------------------------------------------

# This file provides a code frame for existing/old color palettes.

# Information: ------

# cur_pals: "nottingham_1", "nottingham_2", "nottingham_3" (3)

# inst: "University of Nottingham" 
# country: England / UK
# inst_URL: <https://www.nottingham.ac.uk>

# Color source: HTML: / PDF 
# color_URL: <https://www.nottingham.ac.uk/brand/visual/colour.aspx>
# Last check: 2023-09-03


# Colors: ------

# Color definitions: 

# 1: Primary colours ----

# Primary colour

# Nottingham blue is the key colour for the university and should feature on all assets. 
# The deep, rich colour helps the university to be recognisable and 
# it’s also associated with trust and respect.

# Black is no longer part of the Nottingham palette and 
# Nottingham blue should be used as a replacement (this includes body copy).

# There are five approved tints that can also be used for variety and to assist legibility. 
# HEX codes have been provided for each tint, and these should be used when creating digital artwork, 
# rather than using opacity.

# You must ensure you use the correct colour output (RGB for digital and CMYK for print) 
# for the asset and its usage.

# Nottingham blue:
#  CMYK: 100, 79, 47, 56
#  RGB: R16, G38, B59
#  HEX: "#10263B"
#  PMS: 539 C
# 
# 5 tints:
#   80%: "#405162"
#   60%: "#707D89"
#   40%: "#9FA8B1"
#   20%: "#CFD4D8"
#   05%: "#F3F4F5"



color_nottingham_1 <- c("#10263B", 
                        "#405162", "#707D89", "#9FA8B1", "#CFD4D8", "#F3F4F5")
names_nottingham_1 <- c("Nottingham blue", 
                        "Nottingham blue 80", "Nottingham blue 60", "Nottingham blue 40", "Nottingham blue 20", "Nottingham blue 5")


# 2: Supporting colours ----

# Supporting palette
#    
# Our supporting colours are accents. 
# They add warmth and vibrancy and can elevate designs. 
# Inspired by the University of Nottingham campus, key brand messages and the city of Nottingham, 
# nine colours build up the palette to complement our primary Nottingham Blue.
#    
# The palette should be used sparingly, 
# with a maximum of two supporting colours in any one asset.
#    
# Where colour is used within an asset, Nottingham Blue needs to be visually dominant and 
# the supporting palette should be less than half of the make-up of colour within the asset.
#    
# Supporting colours can and should be used for campaigns and initiatives, 
# to help audience recognition and aid navigation.
#    
# You must ensure you use the correct colour output for the asset and its usage 
# (RGB for digital and CMYK for print), as values have been created to keep the most vibrancy in print and the best colour representation across digital channels.
#    
# Each colour has five tints that can also be used for variety and to assist legibility. HEX codes have been provided for each tint, 
# and these should be used when creating digital artwork, rather than using opacity.
# 
# Jubilee Red	          Mandarin Orange 	    Rebel’s Gold
# CMYK: 19, 98, 80, 10  CMYK: 0, 58, 95, 0    CMYK: 14, 27, 97, 3
# RGB: R185, G28, B46   RGB: R249, G129, B9   RGB: R222, G180, B6
# HEX: "#B91C2E"        HEX: "#F98109"        HEX: "#DEB406"
# 
# 5 Jubilee Red	tints:
#   80%: #C74958
#   60%: #D57782
#   40%: #E3A4AB
#   20%: #F1D2D5
#   05%: #FCF4F5
# 
# 5 Mandarin Orange tints:
#   80%: #FA9A3A
#   60%: #FBB36B
#   40%: #FDCD9D
#   20%: #FEE6CE
#   05%: #FFF9F3
#   
# 5 Rebel’s Gold tints:
#   80%: #E5C338
#   60%: #EBD26A
#   40% :#F2E19B
#   20%: #F8F0CD
#   05%: #FDFBF3
# 
# Pioneering Pink 	   Civic Purple	         Forest Green
# CMYK: 9, 91, 31, 0   CMYK: 65, 94, 2, 0    CMYK: 91, 35, 90, 31 
# RGB: R215, G51, B108 RGB: R121, G45, B133  RGB: R0, G95, B54 
# HEX: #D7336C         HEX: #792D85          HEX: #005F36 
# 
# 5 Pioneering Pink tints:
#   80%: #DF5C89
#   60%: #E785A7
#   40%: #EFADC4
#   20%: #F7D6E2
#   05%: #FDF5F8
#   
# 5 Civic Purple tints:
#   80%: #94579D
#   60%: #AF81B6
#   40%: #C9ABCE
#   20%: #E4D5E7
#   05%: #F8F5F9
#   
# 5 Forest Green tints:
#   80%: #337F5E
#   60%: #669F86
#   40%: #99BFAF
#   20%: #CCDFD7
#   05%: #F2F7F5
# 
#   
# Bramley Apple	        Trent Turquoise	      Malaysia Sky Blue
# CMYK: 50, 0, 100, 0   CMYK: 70, 2, 37, 0    CMYK: 80, 18, 18, 0
# RGB: R147, G213, B0   RGB: R55, G180, B176  RGB: R0, G155, B193
# HEX: #93D500          HEX: #37B4B0          HEX: #009BC1
#   
# 5 Bramley Apple tints:
#   80%: #A9DD33
#   60%: #BEE666
#   40%: #D4EE99
#   20%: #E9F7CC
#   05%: #FAFDF2
#   
# 5 Trent Turquoise tints:
#   80%: #5FC3C0
#   60%: #87D2D0
#   40%: #AFE1DF
#   20%: #D7F0EF
#   05%: #F5FBFB
#   
# 5 Malaysia Sky Blue tints:
#   80%: #33AFCD
#   60%: #66C3DA
#   40%: #99D7E6
#   20%: #CCEBF3
#   05%: #F2FAFC

color_nottingham_2 <- c("#B91C2E", "#C74958", "#D57782", "#E3A4AB", "#F1D2D5", "#FCF4F5", 
                        "#F98109", "#FA9A3A", "#FBB36B", "#FDCD9D", "#FEE6CE", "#FFF9F3", 
                        "#DEB406", "#E5C338", "#EBD26A", "#F2E19B", "#F8F0CD", "#FDFBF3", 
                        "#D7336C", "#DF5C89", "#E785A7", "#EFADC4", "#F7D6E2", "#FDF5F8", 
                        "#792D85", "#94579D", "#AF81B6", "#C9ABCE", "#E4D5E7", "#F8F5F9", 
                        "#005F36", "#337F5E", "#669F86", "#99BFAF", "#CCDFD7", "#F2F7F5", 
                        "#93D500", "#A9DD33", "#BEE666", "#D4EE99", "#E9F7CC", "#FAFDF2", 
                        "#37B4B0", "#5FC3C0", "#87D2D0", "#AFE1DF", "#D7F0EF", "#F5FBFB", 
                        "#009BC1", "#33AFCD", "#66C3DA", "#99D7E6", "#CCEBF3", "#F2FAFC")

names_nottingham_2 <- c("Jubilee red", "Jubilee red 80", "Jubilee red 60", "Jubilee red 40", "Jubilee red 20", "Jubilee red 5", 
                        "Mandarin orange", "Mandarin orange 80", "Mandarin orange 60", "Mandarin orange 40", "Mandarin orange 20", "Mandarin orange 5", 
                        "Rebels gold", "Rebels gold 80", "Rebels gold 60", "Rebels gold 40", "Rebels gold 20", "Rebels gold 5", 
                        "Pionieering pink", "Pionieering pink 80", "Pionieering pink 60", "Pionieering pink 40", "Pionieering pink 20", "Pionieering pink 5", 
                        "Civic purple", "Civic purple 80", "Civic purple 60", "Civic purple 40", "Civic purple 20", "Civic purple 5", 
                        "Forest green", "Forest green 80", "Forest green 60", "Forest green 40", "Forest green 20", "Forest green 5", 
                        "Bramely apple", "Bramely apple 80", "Bramely apple 60", "Bramely apple 40", "Bramely apple 20", "Bramely apple 5", 
                        "Trent turqouise", "Trent turqouise 80", "Trent turqouise 60", "Trent turqouise 40", "Trent turqouise 20", "Trent turqouise 5", 
                        "Malaysia sky blue", "Malaysia sky blue 80", "Malaysia sky blue 60", "Malaysia sky blue 40", "Malaysia sky blue 20", "Malaysia sky blue 5")


# +++ here now +++ 


# 3: Neutral colours ----

# Neutral palette
# 
# To accompany Nottingham Blue and the supporting palette,
# a small neutral palette can be used. This is made up of a light/warm grey and white.
# 
# These can be used on all designs where appropriate, and do not count towards the maximum two supporting colours per design and
# are permitted to make up over half of the designed asset, as these would be best used for text (white only) or backgrounds.
# 
# Portland Stone has a 40% tint available to create more accessible designs,
# more information on this can be found within the ‘digital backgrounds’ section.
# 
# Portland stone:
#  CMYK: 3, 3, 8, 0
#  RGB: R250, G246, B239
#  HEX: #FAF6EF
# 
#  40% tint: #FDFBF9
# 
# White:
# CMYK: 0, 0, 0, 0
# RGB: R255, G255, B255
# HEX: #FFFFFF

color_nottingham_3 <- c("#FAF6EF", "#FDFBF9", "#FFFFFF")
names_nottingham_3 <- c("Portland stone", "Portland stone 40", "white")


# 4: Digital backgrounds ----

# Digital backgrounds 
# 
# Using white as a background for digital applications can be difficult to read. You should instead use either a 5% tint of Nottingham Blue or a 40% tint of Portland Stone to create more accessible designs. 
# HEX codes can be found for these in the ‘neutral palette’ section and the ‘primary colour’ section. 
# 



# Color palette(s):

# - nottingham_1: Primary colours of the University of Nottingham ------

#' Primary colours of the University of Nottingham, England/UK  
#'
#' \code{nottingham_1} provides the primary colour and five corresponding tints   
#' of the \href{https://www.nottingham.ac.uk}{University of Nottingham}, England/UK.
#'
#' \code{Nottingham blue} is the key colour for the university 
#' and should feature on all assets. 
#' It is defined as \code{CMYK: 100, 79, 47, 56}, \code{PMS: 539 C}, 
#' \code{RGB: R16, G38, B59}, or \code{HEX: "#10263B"}. 
#' 
#' @details 
#' The deep, rich colour helps the university to be recognisable and 
#' it’s also associated with trust and respect. 
#' The colour "black" is no longer part of the Nottingham palette and 
#' \code{Nottingham blue} should be used as a replacement (this includes body copy).
#' 
#' There are five approved tints that can also be used for variety and to assist legibility. 
#' HEX codes have been provided for each tint, and these should be used when creating digital artwork, 
#' rather than using opacity.
#' 
#' Users must choose the correct colour output (RGB for digital and CMYK for print) 
#' for the asset and its usage.
#' 
#' \code{nottingham_1} uses the HEX color definitions.
#' 
#' @return 
#' A named vector of colours (HEX/HTML codes of type character).
#'
#' @author 
#' \strong{unicol}, 2023-09-03.
#'
#' @source 
#' Colour definitions are based on the UoN's 
#' \href{https://www.nottingham.ac.uk/brand/visual/colour.aspx}{Colour guidelines}.
#'
#' @examples
#' nottingham_1
#' unikn::seecol(nottingham_1, main = "University of Nottingham 1") # view colour palette
#'
#' @family UK university color palettes
#'
#' @seealso
#' \code{\link{nottingham_2}} for supporting colours of the University of Nottingham;
#' \code{\link{nottingham_3}} for neutral colours of the University of Nottingham;
#' \code{\link{seecol}} for viewing and comparing colour palettes;
#' \code{\link{usecol}} for using colour palettes;
#' \code{\link{simcol}} for finding similar colours;
#' \code{\link{newpal}} for defining new colour palettes;
#' \code{\link{grepal}} for finding named colours.
#'
#' @export

nottingham_1 <- unikn::newpal(col = color_nottingham_1, 
                              names = names_nottingham_1, 
                              as_df = FALSE)

# # Check: 
# unikn::seecol(nottingham_1, main = "University of Nottingham 1")



# - Accent/supporting colours) of the University of Nottingham ------ 

#' Supporting colours of the University of Nottingham, England/UK  
#'
#' \code{nottingham_2} provides the nine supporting colours and five corresponding tints 
#' (per colour) of the \href{https://www.nottingham.ac.uk}{University of Nottingham}, England/UK.
#'
#' The supporting colours are accents. They add warmth and vibrancy and can elevate designs.
#' 
#' @details 
#' Inspired by the \href{https://www.nottingham.ac.uk}{University of Nottingham} campus, 
#' key brand messages and the city of Nottingham, nine colours build up 
#' the palette to complement the primary \code{Nottingham blue} (see \code{\link{nottingham_1}}).
#' 
#' The supporting palette should be used sparingly,
#' with a maximum of two supporting colours in any one asset.
#' 
#' Where colour is used within an asset, \code{Nottingham blue} needs to be visually dominant and
#' the supporting palette should be less than half of the make-up of colour within the asset.
#' 
#' Supporting colours can and should be used for campaigns and initiatives, 
#' to help audience recognition and aid navigation.
#' 
#' Users must choose the correct colour output for the asset and its usage
#' (RGB for digital and CMYK for print), as values have been created 
#' to keep the most vibrancy in print and the best colour representation across digital channels.
#' 
#' Each colour has five tints that can also be used for variety and to assist legibility. 
#' HEX codes have been provided for each tint, and these should be used when 
#' creating digital artwork, rather than using opacity.
#' 
#' \code{nottingham_2} uses the HEX color definitions.
#' 
#' @return 
#' A named vector of colours (HEX/HTML codes of type character).
#'
#' @author 
#' \strong{unicol}, 2023-09-04.
#'
#' @source 
#' Colour definitions are based on the UoN's 
#' \href{https://www.nottingham.ac.uk/brand/visual/colour.aspx}{Colour guidelines}.
#'
#' @examples
#' nottingham_2
#' main_cols <- seq(1, 49, by = 6)
#' unikn::seecol(nottingham_2[main_cols], main = "Main supporting colors of UoN")
#'
#' @family UK university color palettes
#'
#' @seealso
#' \code{\link{nottingham_1}} for primary colours of the University of Nottingham;
#' \code{\link{nottingham_3}} for neutral colours of the University of Nottingham;
#' \code{\link{seecol}} for viewing and comparing colour palettes;
#' \code{\link{usecol}} for using colour palettes;
#' \code{\link{simcol}} for finding similar colours;
#' \code{\link{newpal}} for defining new colour palettes;
#' \code{\link{grepal}} for finding named colours.
#'
#' @export

nottingham_2 <- unikn::newpal(col = color_nottingham_2, 
                              names = names_nottingham_2, 
                              as_df = FALSE)

# # Check:
# unikn::seecol(nottingham_2, main = "University of Nottingham 2: Supporting Colors")
# main_cols <- seq(1, 54, by = 6)
# unikn::seecol(nottingham_2[main_cols], main = "Main supporting colors of UoN 2")



# - Neutral colours of the University of Nottingham ------ 


#' Neutral colours of the University of Nottingham, England/UK  
#'
#' \code{nottingham_3} provides three neutral colours  
#' of the \href{https://www.nottingham.ac.uk}{University of Nottingham}, England/UK.
#'
#' To accompany the primary \code{Nottingham blue} (see \code{\link{nottingham_1}}) 
#' and the supporting palette (see \code{\link{nottingham_2}})
#' a small neutral palette can be used. 
#' This is made up of a light/warm grey and \code{"white"}.
#'  
#' @details 
#' The neutral colours of \code{nottingham_3} can be used on all designs 
#' where appropriate, do not count towards the maximum two supporting colours per design and 
#' are permitted to make up over half of the designed asset, 
#' as these would be best used for text (white only) or backgrounds.
#' 
#' The neutral color \code{Portland stone} is defined as 
#' \code{CMYK: 3, 3, 8, 0}, \code{RGB: R250, G246, B239}, or \code{HEX: "#FAF6EF"}. 
#' 
#' \code{Portland stone} has a 40% tint available (defined as \code{HEX: "#FDFBF9"}) 
#' to create more accessible designs. 
#' 
#' More information on accessibility and permissible combinations can be found in  
#' the ‘digital backgrounds’ section of UoN's 
#' \href{https://www.nottingham.ac.uk/brand/visual/colour.aspx}{Colour guidelines}.
#' 
#' \code{nottingham_2} uses the HEX color definitions.
#' 
#' @return 
#' A named vector of colours (HEX/HTML codes of type character).
#'
#' @author 
#' \strong{unicol}, 2023-09-04.
#'
#' @source 
#' Colour definitions are based on the UoN's 
#' \href{https://www.nottingham.ac.uk/brand/visual/colour.aspx}{Colour guidelines}.
#'
#' @examples
#' nottingham_3
#' unikn::seecol(nottingham_3, col_bg = "lightgrey",  
#'               main = "Neutral colors of University of Nottingham 3")
#'
#' @family UK university color palettes
#'
#' @seealso
#' \code{\link{nottingham_1}} for primary colours of the University of Nottingham;
#' \code{\link{nottingham_2}} for supporting colours of the University of Nottingham; 
#' \code{\link{seecol}} for viewing and comparing colour palettes;
#' \code{\link{usecol}} for using colour palettes;
#' \code{\link{simcol}} for finding similar colours;
#' \code{\link{newpal}} for defining new colour palettes;
#' \code{\link{grepal}} for finding named colours.
#'
#' @export

nottingham_3 <- newpal(col = color_nottingham_3, 
                       names = names_nottingham_3,
                       as_df = FALSE)


# Check:
# seecol(pal_nottingham_3, main = "University of Nottingham Neutral Palette")


## ToDo: -----

# - etc. ----

## eof. ----
