% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_set_plot_file_suffix}
\alias{umx_set_plot_file_suffix}
\title{Set output suffix used in umx SEM diagram files saved to disk.}
\usage{
umx_set_plot_file_suffix(umx.plot.suffix = NULL, silent = FALSE)
}
\arguments{
\item{umx.plot.suffix}{The suffix for plot files (if empty current value is returned). "TRUE", toggles setting.}

\item{silent}{If TRUE, no message will be printed.}
}
\value{
\itemize{
\item Current setting
}
}
\description{
\code{umx} SEM diagram files can have a suffix of "gv" (default) or  "dot".
Interrogate the setting by calling with no value: it will return the current setting.
To change the setting call with "gv" or "dot". Or use TRUE to toggle the setting.
}
\examples{
umx_set_plot_file_suffix() # print current state
old = umx_set_plot_file_suffix(silent = TRUE) # store current value
umx_set_plot_file_suffix("dot")
umx_set_plot_file_suffix("gv")
umx_set_plot_file_suffix(old) # reinstate
}
\references{
\itemize{
\item \url{https://tbates.github.io},  \url{https://github.com/tbates/umx}
}
}
\seealso{
Other Get and set: 
\code{\link{umx}},
\code{\link{umx_get_checkpoint}()},
\code{\link{umx_get_options}()},
\code{\link{umx_set_auto_plot}()},
\code{\link{umx_set_auto_run}()},
\code{\link{umx_set_checkpoint}()},
\code{\link{umx_set_condensed_slots}()},
\code{\link{umx_set_cores}()},
\code{\link{umx_set_data_variance_check}()},
\code{\link{umx_set_dollar_symbol}()},
\code{\link{umx_set_optimization_options}()},
\code{\link{umx_set_optimizer}()},
\code{\link{umx_set_plot_format}()},
\code{\link{umx_set_plot_use_hrbrthemes}()},
\code{\link{umx_set_separator}()},
\code{\link{umx_set_silent}()},
\code{\link{umx_set_table_format}()}
}
\concept{Get and set}
