% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaleDiagnosis.R
\name{scaleDiagnosis}
\alias{scaleDiagnosis}
\alias{print.scaleDiagnosis}
\alias{scaleDiagnosis_partial}
\alias{knit_print.scaleDiagnosis}
\title{scaleDiagnosis}
\usage{
scaleDiagnosis(
  data = NULL,
  items = NULL,
  plotSize = 180,
  sizeMultiplier = 1,
  axisLabels = "none",
  scaleReliability.ci = FALSE,
  conf.level = 0.95,
  normalHist = TRUE,
  poly = TRUE,
  digits = 3,
  headingLevel = 3,
  scaleName = NULL,
  ...
)

\method{print}{scaleDiagnosis}(x, digits = x$digits, ...)

scaleDiagnosis_partial(
  x,
  headingLevel = x$input$headingLevel,
  quiet = TRUE,
  echoPartial = FALSE,
  partialFile = NULL,
  ...
)

\method{knit_print}{scaleDiagnosis}(
  x,
  headingLevel = x$headingLevel,
  quiet = TRUE,
  echoPartial = FALSE,
  partialFile = NULL,
  ...
)
}
\arguments{
\item{data}{A dataframe containing the items in the scale. All variables in
this dataframe will be used if items is NULL.}

\item{items}{If not NULL, this should be a character vector with the names
of the variables in the dataframe that represent items in the scale.}

\item{plotSize}{Size of the final plot in millimeters.}

\item{sizeMultiplier}{Allows more flexible control over the size of the plot
elements}

\item{axisLabels}{Passed to ggpairs function to set axisLabels.}

\item{scaleReliability.ci}{TRUE or FALSE: whether to compute confidence
intervals for Cronbach's Alpha and Omega (uses bootstrapping function in
MBESS, takes a while).}

\item{conf.level}{Confidence of confidence intervals for reliability
estimates (if requested with scaleReliability.ci).}

\item{normalHist}{Whether to use the default ggpairs histogram on the
diagonal of the scattermatrix, or whether to use the \code{\link[=normalHist]{normalHist()}} version.}

\item{poly}{Whether to also request the estimates based on the polychoric
correlation matrix when calling \code{\link[=scaleStructure]{scaleStructure()}}.}

\item{digits}{The number of digits to pass to the \code{print} method for the
descriptives dataframe.}

\item{headingLevel}{The level of the heading (number of hash characters to insert
before the heading, to be rendered as headings of that level in Markdown).}

\item{scaleName}{Optionally, a name for the scale to print as heading for
the results.}

\item{...}{Additional arguments for \code{scaleDiagnosis()} are passed on to
\code{\link[=scatterMatrix]{scatterMatrix()}}, and additional arguments for the \code{print} method are passed
to the default \code{print} method.}

\item{x}{The object to print.}

\item{quiet}{Whether to be chatty (\code{FALSE}) or quiet (\code{TRUE}).}

\item{echoPartial}{Whether to show the code in the partial (\code{TRUE}) or hide it (\code{FALSE}).}

\item{partialFile}{The file with the Rmd partial (if you want to overwrite the default).}
}
\value{
An object with the input and several output variables. Most notably:
\item{scaleReliability}{The results of scaleReliability.} \item{pca}{A
Principal Components Analysis} \item{fa}{A Factor Analysis}
\item{describe}{Decriptive statistics about the items}
\item{scatterMatrix}{A scattermatrix with histograms on the diagonal and
correlation coefficients in the upper right half.}
}
\description{
scaleDiagnosis provides a number of diagnostics for a scale (an aggregative
measure consisting of several items).
}
\details{
Function to generate an object with several useful statistics and a plot to
assess how the elements (usually items) in a scale relate to each other,
such as Cronbach's Alpha, omega, the Greatest Lower Bound, a factor
analysis, and a correlation matrix.
}
\examples{

### Note: the 'not run' is simply because running takes a lot of time,
###       but these examples are all safe to run!
\dontrun{
### This will prompt the user to select an SPSS file
scaleDiagnosis();

### Generate a datafile to use
exampleData <- data.frame(item1=rnorm(100));
exampleData$item2 <- exampleData$item1+rnorm(100);
exampleData$item3 <- exampleData$item1+rnorm(100);
exampleData$item4 <- exampleData$item2+rnorm(100);
exampleData$item5 <- exampleData$item2+rnorm(100);

### Use a selection of two variables
scaleDiagnosis(data=exampleData, items=c('item2', 'item4'));

### Use all items
scaleDiagnosis(data=exampleData);
}

}
\author{
Gjalt-Jorn Peters

Maintainer: Gjalt-Jorn Peters \href{mailto:gjalt-jorn@userfriendlyscience.com}{gjalt-jorn@userfriendlyscience.com}
}
\keyword{univar}
\keyword{utilities}
