% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confIntV.R
\name{cramersV}
\alias{cramersV}
\alias{confIntV}
\alias{print.CramersV}
\alias{print.confIntV}
\title{Cramer's V and its confidence interval}
\usage{
cramersV(x, y = NULL, digits = 2)

\method{print}{CramersV}(x, digits = x$input$digits, ...)

confIntV(
  x,
  y = NULL,
  conf.level = 0.95,
  samples = 500,
  digits = 2,
  method = c("bootstrap", "fisher"),
  storeBootstrappingData = FALSE
)

\method{print}{confIntV}(x, digits = x$input$digits, ...)
}
\arguments{
\item{x}{Either a crosstable to analyse, or one of two vectors to use to
generate that crosstable. The vector should be a factor, i.e. a categorical
variable identified as such by the 'factor' class).}

\item{y}{If x is a crosstable, y can (and should) be empty. If x is a
vector, y must also be a vector.}

\item{digits}{Minimum number of digits after the decimal point to show in
the result.}

\item{\dots}{Any additional arguments are passed on to the \code{print} function.}

\item{conf.level}{Level of confidence for the confidence interval.}

\item{samples}{Number of samples to generate when bootstrapping.}

\item{method}{Whether to use Fisher's Z or bootstrapping to compute the
confidence interval.}

\item{storeBootstrappingData}{Whether to store (or discard) the data
generating during the bootstrapping procedure.}
}
\value{
A point estimate or a confidence interval for Cramer's V, an effect
size to describe the association between two categorical variables.
}
\description{
These functions compute the point estimate and confidence interval for
Cramer's V.
}
\examples{
### Get confidence interval for Cramer's V
### Note that by using 'table', and so removing the raw data, inhibits
### bootstrapping, which could otherwise take a while.
confIntV(table(infert$education, infert$induced));

}
\keyword{bivar}
