% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlp_cooccurrence.R
\name{as_cooccurrence}
\alias{as_cooccurrence}
\title{Convert a matrix to a co-occurrence data.frame}
\usage{
as_cooccurrence(x)
}
\arguments{
\item{x}{a matrix or sparseMatrix}
}
\value{
a data.frame with columns term1, term2 and cooc where the data in cooc contain 
the content of the cells in the matrix for the combination of term1 and term2
}
\description{
Use this function to convert the cells of a matrix to a 
co-occurrence data.frame containing fields term1, term2 and cooc where each row of the resulting
data.frame contains the value of a cell in the matrix if the cell is not empty.
}
\examples{
data(brussels_reviews_anno)
x <- subset(brussels_reviews_anno, language == "nl")
dtm <- document_term_frequencies(x = x, document = "doc_id", term = "token")
dtm <- document_term_matrix(dtm)

correlation <- dtm_cor(dtm)
cooc <- as_cooccurrence(correlation)
head(cooc)
}
