% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglik.R
\name{extract_log_lik}
\alias{extract_log_lik}
\alias{extract_log_lik,ubmsFit-method}
\alias{extract_log_lik,ubmsFitDistsamp-method}
\title{Extract Pointwise Log-likelihood From Model}
\usage{
extract_log_lik(object, parameter_name = "log_lik", merge_chains = TRUE)
}
\arguments{
\item{object}{A \code{ubmsFit} or \code{stanfit} object}

\item{parameter_name}{The name of the log-likelihood parameter in the
Stan output; ignored when \code{object} is a \code{ubmsFit}}

\item{merge_chains}{If \code{TRUE} (the default), all Markov chains are
merged together (i.e., stacked) and a matrix is returned. If ‘FALSE’
they are kept separate and an array is returned.}
}
\value{
A matrix (samples x sites) or array (samples x chains x sites)
}
\description{
Extracts the pointwise log-likelihood matrix or array from a model.
This is useful as an input for functions in the \code{loo} package.
If called on a \code{ubmsFit} object, the log-likelihood matrix or array
is calculated using the posterior distributions of the parameters; the
log-likelihood values are not actually saved inside the model object.
If called on a \code{stanfit} object, \code{loo::extract_log_lik} is used.
In this case, the log-likelihood must be saved as one of the output
parameters in Stan.
}
