% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment.R
\name{augment.tune_results}
\alias{augment.tune_results}
\alias{augment.resample_results}
\alias{augment.last_fit}
\title{Augment data with holdout predictions}
\usage{
\method{augment}{tune_results}(x, ..., parameters = NULL)

\method{augment}{resample_results}(x, ...)

\method{augment}{last_fit}(x, ...)
}
\arguments{
\item{x}{An object resulting from one of the \verb{tune_*()} functions,
\code{fit_resamples()}, or \code{last_fit()}. The control specifications for these
objects should have used the option \code{save_pred = TRUE}.}

\item{...}{Not currently used.}

\item{parameters}{A data frame with a single row that indicates what
tuning parameters should be used to generate the predictions (for \verb{tune_*()}
objects only). If \code{NULL}, \code{select_best(x)} will be used with the first
metric and, if applicable, the first evaluation time point, used to
create \code{x}.}
}
\value{
A data frame with one or more additional columns for model
predictions.
}
\description{
For \code{tune} objects that use resampling, these \code{augment()} methods will add
one or more columns for the hold-out predictions (i.e. from the assessment
set(s)).
}
\details{
For some resampling methods where rows may be replicated in multiple
assessment sets, the prediction columns will be averages of the holdout
results. Also, for these methods, it is possible that all rows of the
original data do not have holdout predictions (like a single bootstrap
resample). In this case, all rows are return and a warning is issued.

For objects created by \code{last_fit()}, the test set data and predictions are
returned.

Unlike other \code{augment()} methods, the predicted values for regression models
are in a column called \code{.pred} instead of \code{.fitted} (to be consistent with
other tidymodels conventions).

For regression problems, an additional \code{.resid} column is added to the
results.
}
