% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_fil_seas_adj.R
\name{ts_fil_seas_adj}
\alias{ts_fil_seas_adj}
\title{Seasonal Adjustment}
\usage{
ts_fil_seas_adj(frequency = NULL)
}
\arguments{
\item{frequency}{Frequency of the time series. It is an optional parameter.
It can be configured when the frequency of the time series is known.}
}
\value{
a \code{ts_fil_seas_adj} object.
}
\description{
Removes the seasonal component from the time series without affecting the other components.
}
\examples{
# time series with noise
library(daltoolbox)
data(tsd)
tsd$y[9] <- 2*tsd$y[9]

# filter
filter <- ts_fil_seas_adj(frequency = 26)
filter <- fit(filter, tsd$y)
y <- transform(filter, tsd$y)

# plot
plot_ts_pred(y=tsd$y, yadj=y)
}
