% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blum.R
\name{blum}
\alias{blum}
\title{Blum index of (im)balance.}
\usage{
blum(phy, normalization = FALSE)
}
\arguments{
\item{phy}{phylogeny or ltable}

\item{normalization}{because the Blum index sums over all nodes,
the resulting statistic tends to be correlated with the number of extant
tips. Normalization can be performed by dividing by the number of extant
tips.}
}
\value{
Blum index of imbalance
}
\description{
The Blum index of imbalance (also known as the s-shape
statistic) calculates the sum of \eqn{log(N-1)} over all internal nodes,
where N represents the total number of extant tips connected to that node.
An alternative implementation can be found in the Castor R package.
}
\examples{
simulated_tree <- ape::rphylo(n = 10, birth = 1, death = 0)
  balanced_tree <- treestats::create_fully_balanced_tree(simulated_tree)
  unbalanced_tree <- treestats::create_fully_unbalanced_tree(simulated_tree)
  blum(balanced_tree)
  blum(unbalanced_tree) # should be higher
}
\references{
M. G. B. Blum and O. Francois (2006). Which random processes
describe the Tree of Life? A large-scale study of phylogenetic tree
imbalance. Systematic Biology. 55:685-691.
}
