% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bw2bwi2022de.R
\name{bw2bwi2022de}
\alias{bw2bwi2022de}
\title{Convert Preprocessed Data Back to Original Units}
\usage{
bw2bwi2022de(x)
}
\arguments{
\item{x}{A tree data set, typically
\code{get(data("trees", package = "treePlotArea"))}.}
}
\value{
A tree data set prepared to work with the package.
}
\description{
The data tree coming with this package was processed by Gerald Kaendler for
the
country of  Baden-Wuerttemberg, and is the reference for testing as he
adjusted diameter measurements to breast height where they had been measured
in diverging heights (due to deformations of trees at breast height).
\emph{Which we really need to do.}
But he did some other things we need to revert if we want to follow the
standards
from the federal database. He
\enumerate{
    \item converted the diameter at breast height from millimeter to
    centimeter and renamed it,
    \item converted horizontal distance from centimeter to meter and renamed
    it.
}
So we add two variables holding the diameter in millimeter and the horizontal
distance in centimeter, named by the output of \cr
\code{getOption("treePlotArea")[["angle_counts"]][["dbh"]]}\cr
and\cr
\code{getOption("treePlotArea")[["angle_counts"]][["distance"]]}\cr
respectively.
}
\examples{
trees <- get(data("trees", package = "treePlotArea"))
summary(trees)
angle_counts <- bw2bwi2022de(trees)
summary(angle_counts)
}
\seealso{
Other data functions: 
\code{\link{select_valid_angle_count_trees}()}
}
\concept{data functions}
