% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geocoding.R
\name{geocoding}
\alias{geocoding}
\title{Geocoding (Search)}
\usage{
geocoding(
  query,
  within.country = NA,
  format.name = NA,
  format.exclude.country = NA,
  bounds = NA
)
}
\arguments{
\item{query}{A query to geocode. Can be an address, a postcode or a venue.}

\item{within.country}{Only return the results that are within the specified country.
If no results are found it will return the country itself. Optional. Format:ISO 3166-1 alpha-2 or alpha-3}

\item{format.name}{Format the name field of the response to a well formatted, human-readable address of the location. Experimental. Optional.}

\item{format.exclude.country}{Exclude the country from the formatted name field (used only if format.name is equal true). Optional.}

\item{bounds}{Used to limit the results to a bounding box. Expecting a character vector with four floats,
marking a south-east and north-west corners of a rectangle: min-latitude,min-longitude,max-latitude,max-longitude.
e.g. bounds for Scandinavia c(54.16243,4.04297,71.18316,31.81641). Optional.}
}
\value{
API response parsed as list and as a raw json
}
\description{
Match a query string to geographic coordinates.
}
\details{
See \url{https://docs.traveltime.com/api/reference/geocoding-search/} for details
}
\examples{
\dontrun{
geocoding('Parliament square')
}
}
