% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_nextafter}
\alias{torch_nextafter}
\title{Nextafter}
\usage{
torch_nextafter(self, other)
}
\arguments{
\item{self}{(Tensor) the first input tensor}

\item{other}{(Tensor) the second input tensor}
}
\description{
Nextafter
}
\section{nextafter(input, other, *, out=None) -> Tensor }{


Return the next floating-point value after \code{input} towards \code{other}, elementwise.

The shapes of \code{input} and \code{other} must be
broadcastable .
}

\examples{
if (torch_is_installed()) {

eps <- torch_finfo(torch_float32())$eps
torch_nextafter(torch_tensor(c(1, 2)), torch_tensor(c(2, 1))) == torch_tensor(c(eps + 1, 2 - eps))
}
}
