% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_count_nonzero}
\alias{torch_count_nonzero}
\title{Count_nonzero}
\usage{
torch_count_nonzero(self, dim = NULL)
}
\arguments{
\item{self}{(Tensor) the input tensor.}

\item{dim}{(int or tuple of ints, optional) Dim or tuple of dims along which
to count non-zeros.}
}
\description{
Count_nonzero
}
\section{count_nonzero(input, dim=None) -> Tensor }{


Counts the number of non-zero values in the tensor \code{input} along the given \code{dim}.
If no dim is specified then all non-zeros in the tensor are counted.
}

\examples{
if (torch_is_installed()) {

x <- torch_zeros(3,3)
x[torch_randn(3,3) > 0.5] = 1
x
torch_count_nonzero(x)
torch_count_nonzero(x, dim=1)
}
}
