% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anomalize-plotting.R
\name{plot_anomalies}
\alias{plot_anomalies}
\alias{plot_anomalies_decomp}
\alias{plot_anomalies_cleaned}
\title{Visualize Anomalies for One or More Time Series}
\usage{
plot_anomalies(
  .data,
  .date_var,
  .facet_vars = NULL,
  .facet_ncol = 1,
  .facet_nrow = 1,
  .facet_scales = "free",
  .facet_dir = "h",
  .facet_collapse = FALSE,
  .facet_collapse_sep = " ",
  .facet_strip_remove = FALSE,
  .line_color = "#2c3e50",
  .line_size = 0.5,
  .line_type = 1,
  .line_alpha = 1,
  .anom_color = "#e31a1c",
  .anom_alpha = 1,
  .anom_size = 1.5,
  .ribbon_fill = "grey20",
  .ribbon_alpha = 0.2,
  .legend_show = TRUE,
  .title = "Anomaly Plot",
  .x_lab = "",
  .y_lab = "",
  .color_lab = "Anomaly",
  .interactive = TRUE,
  .trelliscope = FALSE,
  .trelliscope_params = list()
)

plot_anomalies_decomp(
  .data,
  .date_var,
  .facet_vars = NULL,
  .facet_scales = "free",
  .line_color = "#2c3e50",
  .line_size = 0.5,
  .line_type = 1,
  .line_alpha = 1,
  .title = "Anomaly Decomposition Plot",
  .x_lab = "",
  .y_lab = "",
  .interactive = TRUE
)

plot_anomalies_cleaned(
  .data,
  .date_var,
  .facet_vars = NULL,
  .facet_ncol = 1,
  .facet_nrow = 1,
  .facet_scales = "free",
  .facet_dir = "h",
  .facet_collapse = FALSE,
  .facet_collapse_sep = " ",
  .facet_strip_remove = FALSE,
  .line_color = "#2c3e50",
  .line_size = 0.5,
  .line_type = 1,
  .line_alpha = 1,
  .cleaned_line_color = "#e31a1c",
  .cleaned_line_size = 0.5,
  .cleaned_line_type = 1,
  .cleaned_line_alpha = 1,
  .legend_show = TRUE,
  .title = "Anomalies Cleaned Plot",
  .x_lab = "",
  .y_lab = "",
  .color_lab = "Legend",
  .interactive = TRUE,
  .trelliscope = FALSE,
  .trelliscope_params = list()
)
}
\arguments{
\item{.data}{A \code{tibble} or \code{data.frame} that has been anomalized by \code{anomalize()}}

\item{.date_var}{A column containing either date or date-time values}

\item{.facet_vars}{One or more grouping columns that broken out into \code{ggplot2} facets.
These can be selected using \code{tidyselect()} helpers (e.g \code{contains()}).}

\item{.facet_ncol}{Number of facet columns.}

\item{.facet_nrow}{Number of facet rows (only used for \code{.trelliscope = TRUE})}

\item{.facet_scales}{Control facet x & y-axis ranges. Options include "fixed", "free", "free_y", "free_x"}

\item{.facet_dir}{The direction of faceting ("h" for horizontal, "v" for vertical). Default is "h".}

\item{.facet_collapse}{Multiple facets included on one facet strip instead of
multiple facet strips.}

\item{.facet_collapse_sep}{The separator used for collapsing facets.}

\item{.facet_strip_remove}{Whether or not to remove the strip and text label for each facet.}

\item{.line_color}{Line color.}

\item{.line_size}{Line size.}

\item{.line_type}{Line type.}

\item{.line_alpha}{Line alpha (opacity). Range: (0, 1).}

\item{.anom_color}{Color for the anomaly dots}

\item{.anom_alpha}{Opacity for the anomaly dots. Range: (0, 1).}

\item{.anom_size}{Size for the anomaly dots}

\item{.ribbon_fill}{Fill color for the acceptable range}

\item{.ribbon_alpha}{Fill opacity for the acceptable range. Range: (0, 1).}

\item{.legend_show}{Toggles on/off the Legend}

\item{.title}{Plot title.}

\item{.x_lab}{Plot x-axis label}

\item{.y_lab}{Plot y-axis label}

\item{.color_lab}{Plot label for the color legend}

\item{.interactive}{If TRUE, returns a \code{plotly} interactive plot.
If FALSE, returns a static \code{ggplot2} plot.}

\item{.trelliscope}{Returns either a normal plot or a trelliscopejs plot (great for many time series)
Must have \code{trelliscopejs} installed.}

\item{.trelliscope_params}{Pass parameters to the \code{trelliscopejs::facet_trelliscope()} function as a \code{list()}.
The only parameters that cannot be passed are:
\itemize{
\item \code{ncol}: use \code{.facet_ncol}
\item \code{nrow}: use \code{.facet_nrow}
\item \code{scales}: use \code{facet_scales}
\item \code{as_plotly}: use \code{.interactive}
}}

\item{.cleaned_line_color}{Line color.}

\item{.cleaned_line_size}{Line size.}

\item{.cleaned_line_type}{Line type.}

\item{.cleaned_line_alpha}{Line alpha (opacity). Range: (0, 1).}
}
\value{
A \code{plotly} or \code{ggplot2} visualization
}
\description{
\code{plot_anomalies()} is an interactive and scalable function for visualizing anomalies in time series data.
Plots are available in interactive \code{plotly} (default) and static \code{ggplot2} format.

\code{plot_anomalies_decomp()}: Takes in data from the \code{anomalize()}
function, and returns a plot of the anomaly decomposition. Useful for interpeting
how the \code{anomalize()} function is determining outliers from "remainder".

\code{plot_anomalies_cleaned()} helps users visualize the before/after of
cleaning anomalies.
}
\examples{
# Plot Anomalies
library(dplyr)

walmart_sales_weekly \%>\%
    filter(id \%in\% c("1_1", "1_3")) \%>\%
    group_by(id) \%>\%
    anomalize(Date, Weekly_Sales) \%>\%
    plot_anomalies(Date, .facet_ncol = 2, .ribbon_alpha = 0.25, .interactive = FALSE)

# Plot Anomalies Decomposition
library(dplyr)

walmart_sales_weekly \%>\%
    filter(id \%in\% c("1_1", "1_3")) \%>\%
    group_by(id) \%>\%
    anomalize(Date, Weekly_Sales, .message = FALSE) \%>\%
    plot_anomalies_decomp(Date, .interactive = FALSE)

# Plot Anomalies Cleaned
library(dplyr)

walmart_sales_weekly \%>\%
    filter(id \%in\% c("1_1", "1_3")) \%>\%
    group_by(id) \%>\%
    anomalize(Date, Weekly_Sales, .message = FALSE) \%>\%
    plot_anomalies_cleaned(Date, .facet_ncol = 2, .interactive = FALSE)

}
