% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairs.R
\name{pairs,stars-method}
\alias{pairs,stars-method}
\title{Pairwise matrix of scatterplot for stars objects}
\usage{
\S4method{pairs}{stars}(
  x,
  hist = TRUE,
  cor = TRUE,
  use = "pairwise.complete.obs",
  maxcells = 1e+05,
  ...
)
}
\arguments{
\item{x}{SpatRaster}

\item{hist}{logical. If TRUE a histogram of the values is shown on the diagonal}

\item{cor}{logical. If TRUE the correlation coefficient is shown in the upper panels}

\item{use}{argument passed to the \code{\link[stats]{cor}} function}

\item{maxcells}{integer. Number of pixels to sample from each layer of a large SpatRaster}

\item{...}{additional arguments (graphical parameters)}
}
\value{
a pairs plot of the attributes of the \code{stars} object.
}
\description{
Pairs plot of attributes for \code{stars} objects. This is equivalent to
\code{\link[terra:pairs]{terra::pairs()}} but works with \code{stars} objects.
}
\examples{
r <- terra::rast(system.file("ex/elev.tif", package = "terra"))
s <- c(r, 1 / r, sqrt(r))
names(s) <- c("elevation", "inverse", "sqrt")
terra::pairs(s)
s_stars <- stars::st_as_stars(s, as_attributes = TRUE)
pairs(s_stars)
}
