% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_collinear.R
\name{filter_collinear}
\alias{filter_collinear}
\alias{filter_collinear.default}
\alias{filter_collinear.stars}
\alias{filter_collinear.SpatRaster}
\alias{filter_collinear.data.frame}
\alias{filter_collinear.matrix}
\title{Filter to retain only variables that have low collinearity}
\usage{
filter_collinear(
  x,
  cutoff = NULL,
  verbose = FALSE,
  names = TRUE,
  to_keep = NULL,
  method = "cor_caret",
  cor_type = "pearson",
  max_cells = Inf,
  ...
)

\method{filter_collinear}{default}(
  x,
  cutoff = NULL,
  verbose = FALSE,
  names = TRUE,
  to_keep = NULL,
  method = "cor_caret",
  cor_type = "pearson",
  max_cells = Inf,
  ...
)

\method{filter_collinear}{stars}(
  x,
  cutoff = NULL,
  verbose = FALSE,
  names = TRUE,
  to_keep = NULL,
  method = "cor_caret",
  cor_type = "pearson",
  max_cells = Inf,
  exhaustive = FALSE,
  ...
)

\method{filter_collinear}{SpatRaster}(
  x,
  cutoff = NULL,
  verbose = FALSE,
  names = TRUE,
  to_keep = NULL,
  method = "cor_caret",
  cor_type = "pearson",
  max_cells = Inf,
  exhaustive = FALSE,
  ...
)

\method{filter_collinear}{data.frame}(
  x,
  cutoff = NULL,
  verbose = FALSE,
  names = TRUE,
  to_keep = NULL,
  method = "cor_caret",
  cor_type = "pearson",
  max_cells = Inf,
  ...
)

\method{filter_collinear}{matrix}(
  x,
  cutoff = NULL,
  verbose = FALSE,
  names = TRUE,
  to_keep = NULL,
  method = "cor_caret",
  cor_type = "pearson",
  max_cells = Inf,
  ...
)
}
\arguments{
\item{x}{A \code{\link[terra:SpatRaster-class]{terra::SpatRaster}} or \code{stars} object, a data.frame (with only
numeric variables)}

\item{cutoff}{A numeric value used as a threshold to remove variables. For,
"cor_caret" and "vif_cor", it is the pair-wise absolute correlation cutoff,
which defaults to 0.7. For "vif_step", it is the variable inflation factor,
which defaults to 10}

\item{verbose}{A boolean whether additional information should be provided on
the screen}

\item{names}{a logical; should the column names be returned \code{TRUE} or the
column index \code{FALSE})?}

\item{to_keep}{A vector of variable names that we want to force in the set
(note that the function will return an error if the correlation among any
of those variables is higher than the cutoff).}

\item{method}{character. One of "cor_caret", "vif_cor" or "vif_step".}

\item{cor_type}{character. For methods that use correlation, which type of
correlation: "pearson", "kendall", or "spearman". Defaults to "pearson"}

\item{max_cells}{positive integer. The maximum number of cells to be used. If
this is smaller than ncell(x), a regular sample of x is used}

\item{...}{additional arguments specific to a given object type}

\item{exhaustive}{boolean. Used only for \code{\link[terra:SpatRaster-class]{terra::SpatRaster}} when
downsampling to \code{max_cells}, if we require the \code{exhaustive} approach in
\code{\link[terra:sample]{terra::spatSample()}}. This is only needed for rasters that are very sparse
and not too large, see the help page of \code{\link[terra:sample]{terra::spatSample()}} for details.}
}
\value{
A vector of names of columns that are below the correlation
threshold (when \code{names = TRUE}), otherwise a vector of indices. Note
that the indices are only for numeric variables (i.e. if factors are
present, the indices do not take them into account).
}
\description{
This method finds a subset of variables that have low collinearity. It
provides three methods: \code{cor_caret}, a stepwise approach to remove variables
with a pairwise correlation above a given cutoff, choosing the variable with
the greatest mean correlation (based on the algorithm in
\code{caret::findCorrelation}); \code{vif_step}, a stepwise approach to remove
variables with an variance inflation factor above a given cutoff (based on
the algorithm in \code{usdm::vifstep}), and \code{vif_cor}, a stepwise approach that,
at each step, find the pair of variables with the highest correlation above
the cutoff and removes the one with the largest vif. such that all have a
correlation below a certain cutoff. There are methods for
\code{\link[terra:SpatRaster-class]{terra::SpatRaster}}, \code{\link{data.frame}} and \code{\link{matrix}}. For
\code{\link[terra:SpatRaster-class]{terra::SpatRaster}} and \code{data.frame}, only numeric variables will be
considered.
}
\references{
Naimi, B., Hamm, N.A.S., Groen, T.A., Skidmore, A.K., and
Toxopeus, A.G. 2014. Where is positional uncertainty a problem for species
distribution modelling?, Ecography 37 (2): 191-203.
}
\author{
for \code{cor_caret}: Original R code by Dong Li, modified by Max Kuhn and
Andrea Manica; for \code{vif_step} and \code{vif_cor}, original algorithm by Babak
Naimi, rewritten by Andrea Manica for \code{tidysdm}
}
