% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_groq.R
\name{send_groq_batch}
\alias{send_groq_batch}
\title{Send a Batch of Messages to the Groq API}
\usage{
send_groq_batch(
  .llms,
  .model = "deepseek-r1-distill-llama-70b",
  .max_tokens = 1024,
  .temperature = NULL,
  .top_p = NULL,
  .frequency_penalty = NULL,
  .presence_penalty = NULL,
  .stop = NULL,
  .seed = NULL,
  .api_url = "https://api.groq.com/",
  .json = FALSE,
  .completion_window = "24h",
  .verbose = FALSE,
  .dry_run = FALSE,
  .overwrite = FALSE,
  .max_tries = 3,
  .timeout = 60,
  .id_prefix = "tidyllm_groq_req_"
)
}
\arguments{
\item{.llms}{A list of LLMMessage objects containing conversation histories.}

\item{.model}{Character string specifying the model to use (default: "deepseek-r1-distill-llama-70b").}

\item{.max_tokens}{Integer specifying the maximum tokens per response (default: 1024).}

\item{.temperature}{Numeric between 0 and 2 controlling response randomness.}

\item{.top_p}{Numeric between 0 and 1 for nucleus sampling.}

\item{.frequency_penalty}{Number between -2.0 and 2.0 to penalize repetition.}

\item{.presence_penalty}{Number between -2.0 and 2.0 to encourage new topics.}

\item{.stop}{One or more sequences where the API will stop generating further tokens.}

\item{.seed}{An integer for deterministic sampling.}

\item{.api_url}{Base URL for the Groq API (default: "https://api.groq.com/").}

\item{.json}{Whether the response should be structured as JSON (default: FALSE).}

\item{.completion_window}{Character string for the batch completion window (default: "24h").}

\item{.verbose}{Logical; if TRUE, prints a message with the batch ID (default: FALSE).}

\item{.dry_run}{Logical; if TRUE, returns the prepared request objects without executing (default: FALSE).}

\item{.overwrite}{Logical; if TRUE, allows overwriting an existing batch ID (default: FALSE).}

\item{.max_tries}{Maximum number of retries to perform the request.}

\item{.timeout}{Integer specifying the request timeout in seconds (default: 60).}

\item{.id_prefix}{Character string to specify a prefix for generating custom IDs when names in \code{.llms} are missing.}
}
\value{
An updated and named list of \code{.llms} with identifiers that align with batch responses, including a \code{batch_id} attribute.
}
\description{
This function creates and submits a batch of messages to the Groq API for asynchronous processing.
}
