% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{tfd_gaussian_process_regression_model}
\alias{tfd_gaussian_process_regression_model}
\title{Posterior predictive distribution in a conjugate GP regression model.}
\usage{
tfd_gaussian_process_regression_model(
  kernel,
  index_points = NULL,
  observation_index_points = NULL,
  observations = NULL,
  observation_noise_variance = 0,
  predictive_noise_variance = NULL,
  mean_fn = NULL,
  jitter = 1e-06,
  validate_args = FALSE,
  allow_nan_stats = FALSE,
  name = "GaussianProcessRegressionModel"
)
}
\arguments{
\item{kernel}{\code{PositiveSemidefiniteKernel}-like instance representing the
GP's covariance function.}

\item{index_points}{\code{float} \code{Tensor} representing finite (batch of) vector(s) of
points in the index set over which the GP is defined. Shape has the
form \verb{[b1, ..., bB, e1, f1, ..., fF]} where \code{F} is the number of feature
dimensions and must equal \code{kernel$feature_ndims} and \code{e1} is the number
(size) of index points in each batch (we denote it \code{e1} to distinguish
it from the numer of inducing index points, denoted \code{e2} below).
Ultimately the GaussianProcess distribution corresponds to an
\code{e1}-dimensional multivariate normal. The batch shape must be
broadcastable with \code{kernel$batch_shape}, the batch shape of
\code{inducing_index_points}, and any batch dims yielded by \code{mean_fn}.}

\item{observation_index_points}{Tensor representing finite collection, or batch
of collections, of points in the index set for which some data has been observed.
Shape has the form [b1, ..., bB, e, f1, ..., fF] where F is the number of
feature dimensions and must equal \code{kernel$feature_ndims}, and e is the number
(size) of index points in each batch. [b1, ..., bB, e] must be broadcastable
with the shape of observations, and [b1, ..., bB] must be broadcastable with
the shapes of all other batched parameters (kernel.batch_shape, index_points, etc).
The default value is None, which corresponds to the empty set of observations,
and simply results in the prior predictive model (a GP with noise of variance
\code{predictive_noise_variance}).}

\item{observations}{Tensor representing collection, or batch of collections,
of observations corresponding to observation_index_points. Shape has the
form [b1, ..., bB, e], which must be brodcastable with the batch and example
shapes of observation_index_points. The batch shape [b1, ..., bB\ ] must be
broadcastable with the shapes of all other batched parameters (kernel.batch_shape,
index_points, etc.). The default value is None, which corresponds to the empty
set of observations, and simply results in the prior predictive model (a GP
with noise of variance \code{predictive_noise_variance}).}

\item{observation_noise_variance}{\code{float} \code{Tensor} representing the variance
of the noise in the Normal likelihood distribution of the model. May be
batched, in which case the batch shape must be broadcastable with the
shapes of all other batched parameters (\code{kernel$batch_shape}, \code{index_points}, etc.).
Default value: \code{0.}}

\item{predictive_noise_variance}{Tensor representing the variance in the posterior
predictive model. If None, we simply re-use observation_noise_variance for the
posterior predictive noise. If set explicitly, however, we use this value. This
allows us, for example, to omit predictive noise variance (by setting this to zero)
to obtain noiseless posterior predictions of function values, conditioned on noisy
observations.}

\item{mean_fn}{callable that acts on \code{index_points} to produce a collection, or
batch of collections, of mean values at index_points. Takes a Tensor of shape
[b1, ..., bB, f1, ..., fF] and returns a Tensor whose shape is broadcastable
with [b1, ..., bB]. Default value: None implies the constant zero function.}

\item{jitter}{\code{float} scalar \code{Tensor} added to the diagonal of the covariance
matrix to ensure positive definiteness of the covariance matrix. Default value: \code{1e-6}.}

\item{validate_args}{Logical, default FALSE. When TRUE distribution parameters are checked
for validity despite possibly degrading runtime performance. When FALSE invalid inputs may
silently render incorrect outputs. Default value: FALSE.}

\item{allow_nan_stats}{Logical, default TRUE. When TRUE, statistics (e.g., mean, mode, variance)
use the value NaN to indicate the result is undefined. When FALSE, an exception is raised if
one or more of the statistic's batch members are undefined.}

\item{name}{name prefixed to Ops created by this class.}
}
\value{
a distribution instance.
}
\description{
Posterior predictive distribution in a conjugate GP regression model.
}
\seealso{
For usage examples see e.g. \code{\link[=tfd_sample]{tfd_sample()}}, \code{\link[=tfd_log_prob]{tfd_log_prob()}}, \code{\link[=tfd_mean]{tfd_mean()}}.

Other distributions: 
\code{\link{tfd_autoregressive}()},
\code{\link{tfd_batch_reshape}()},
\code{\link{tfd_bates}()},
\code{\link{tfd_bernoulli}()},
\code{\link{tfd_beta_binomial}()},
\code{\link{tfd_beta}()},
\code{\link{tfd_binomial}()},
\code{\link{tfd_categorical}()},
\code{\link{tfd_cauchy}()},
\code{\link{tfd_chi2}()},
\code{\link{tfd_chi}()},
\code{\link{tfd_cholesky_lkj}()},
\code{\link{tfd_continuous_bernoulli}()},
\code{\link{tfd_deterministic}()},
\code{\link{tfd_dirichlet_multinomial}()},
\code{\link{tfd_dirichlet}()},
\code{\link{tfd_empirical}()},
\code{\link{tfd_exp_gamma}()},
\code{\link{tfd_exp_inverse_gamma}()},
\code{\link{tfd_exponential}()},
\code{\link{tfd_gamma_gamma}()},
\code{\link{tfd_gamma}()},
\code{\link{tfd_gaussian_process}()},
\code{\link{tfd_generalized_normal}()},
\code{\link{tfd_geometric}()},
\code{\link{tfd_gumbel}()},
\code{\link{tfd_half_cauchy}()},
\code{\link{tfd_half_normal}()},
\code{\link{tfd_hidden_markov_model}()},
\code{\link{tfd_horseshoe}()},
\code{\link{tfd_independent}()},
\code{\link{tfd_inverse_gamma}()},
\code{\link{tfd_inverse_gaussian}()},
\code{\link{tfd_johnson_s_u}()},
\code{\link{tfd_joint_distribution_named_auto_batched}()},
\code{\link{tfd_joint_distribution_named}()},
\code{\link{tfd_joint_distribution_sequential_auto_batched}()},
\code{\link{tfd_joint_distribution_sequential}()},
\code{\link{tfd_kumaraswamy}()},
\code{\link{tfd_laplace}()},
\code{\link{tfd_linear_gaussian_state_space_model}()},
\code{\link{tfd_lkj}()},
\code{\link{tfd_log_logistic}()},
\code{\link{tfd_log_normal}()},
\code{\link{tfd_logistic}()},
\code{\link{tfd_mixture_same_family}()},
\code{\link{tfd_mixture}()},
\code{\link{tfd_multinomial}()},
\code{\link{tfd_multivariate_normal_diag_plus_low_rank}()},
\code{\link{tfd_multivariate_normal_diag}()},
\code{\link{tfd_multivariate_normal_full_covariance}()},
\code{\link{tfd_multivariate_normal_linear_operator}()},
\code{\link{tfd_multivariate_normal_tri_l}()},
\code{\link{tfd_multivariate_student_t_linear_operator}()},
\code{\link{tfd_negative_binomial}()},
\code{\link{tfd_normal}()},
\code{\link{tfd_one_hot_categorical}()},
\code{\link{tfd_pareto}()},
\code{\link{tfd_pixel_cnn}()},
\code{\link{tfd_poisson_log_normal_quadrature_compound}()},
\code{\link{tfd_poisson}()},
\code{\link{tfd_power_spherical}()},
\code{\link{tfd_probit_bernoulli}()},
\code{\link{tfd_quantized}()},
\code{\link{tfd_relaxed_bernoulli}()},
\code{\link{tfd_relaxed_one_hot_categorical}()},
\code{\link{tfd_sample_distribution}()},
\code{\link{tfd_sinh_arcsinh}()},
\code{\link{tfd_skellam}()},
\code{\link{tfd_spherical_uniform}()},
\code{\link{tfd_student_t_process}()},
\code{\link{tfd_student_t}()},
\code{\link{tfd_transformed_distribution}()},
\code{\link{tfd_triangular}()},
\code{\link{tfd_truncated_cauchy}()},
\code{\link{tfd_truncated_normal}()},
\code{\link{tfd_uniform}()},
\code{\link{tfd_variational_gaussian_process}()},
\code{\link{tfd_vector_diffeomixture}()},
\code{\link{tfd_vector_exponential_diag}()},
\code{\link{tfd_vector_exponential_linear_operator}()},
\code{\link{tfd_vector_laplace_diag}()},
\code{\link{tfd_vector_laplace_linear_operator}()},
\code{\link{tfd_vector_sinh_arcsinh_diag}()},
\code{\link{tfd_von_mises_fisher}()},
\code{\link{tfd_von_mises}()},
\code{\link{tfd_weibull}()},
\code{\link{tfd_wishart_linear_operator}()},
\code{\link{tfd_wishart_tri_l}()},
\code{\link{tfd_wishart}()},
\code{\link{tfd_zipf}()}
}
\concept{distributions}
