% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{point_from_distance}
\alias{point_from_distance}
\title{Find latitude and longitude for a certain distance and azimuth from a point.}
\usage{
point_from_distance(
  coord_pair,
  distance,
  azimuth,
  distance_unit = "meters",
  azimuth_unit = c("degrees", "radians")
)
}
\arguments{
\item{coord_pair}{A numeric vector of length 2 with names "lat" and "lng"}

\item{distance}{A distance (in meters) representing the distance away from
the original point to apply}

\item{azimuth}{A azimuth (in units specified in \code{azimuth_unit})
representing the direction to apply the distance from the original point in}

\item{distance_unit}{A string passed to convert_distance
indicating the units of the provided distance.}

\item{azimuth_unit}{A string (either \code{degrees} or \code{radians})
indicating the units of the \code{azimuth} argument}
}
\value{
An object of class \link{terrainr_coordinate_pair}.
}
\description{
Find latitude and longitude for a certain distance and azimuth from a point.
}
\keyword{internal}
