% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Renderer.R
\docType{class}
\name{Renderer}
\alias{Renderer}
\title{\code{Renderer}}
\description{
A class for rendering reports from \code{ContentBlock} into various formats using \code{rmarkdown}.
It supports \code{TextBlock}, \code{PictureBlock}, \code{RcodeBlock}, \code{NewpageBlock}, and \code{TableBlock}.
}
\examples{
\dontshow{if (require("ggplot2")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(yaml)
library(rtables)
library(ggplot2)

ReportCard <- getFromNamespace("ReportCard", "teal.reporter")
Reporter <- getFromNamespace("Reporter", "teal.reporter")
yaml_quoted <- getFromNamespace("yaml_quoted", "teal.reporter")
md_header <- getFromNamespace("md_header", "teal.reporter")
Renderer <- getFromNamespace("Renderer", "teal.reporter")

card1 <- ReportCard$new()
card1$append_text("Header 2 text", "header2")
card1$append_text("A paragraph of default text")
card1$append_plot(
 ggplot(iris, aes(x = Petal.Length)) + geom_histogram()
)

card2 <- ReportCard$new()
card2$append_text("Header 2 text", "header2")
card2$append_text("A paragraph of default text")
lyt <- analyze(split_rows_by(basic_table(), "Day"), "Ozone", afun = mean)
table_res2 <- build_table(lyt, airquality)
card2$append_table(table_res2)
card2$append_rcode("2+2", echo = FALSE)

reporter <- Reporter$new()
reporter$append_cards(list(card1, card2))

yaml_l <- list(
  author = yaml_quoted("NEST"),
  title = yaml_quoted("Report"),
  date = yaml_quoted("07/04/2019"),
  output = list(html_document = list(toc = FALSE))
)

yaml_header <- md_header(as.yaml(yaml_l))

result_path <- Renderer$new()$renderRmd(reporter$get_blocks(), yaml_header)
\dontshow{\}) # examplesIf}
\dontshow{if (require("ggplot2")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(yaml)
library(ggplot2)

ReportCard <- getFromNamespace("ReportCard", "teal.reporter")
Reporter <- getFromNamespace("Reporter", "teal.reporter")
yaml_quoted <- getFromNamespace("yaml_quoted", "teal.reporter")
md_header <- getFromNamespace("md_header", "teal.reporter")
Renderer <- getFromNamespace("Renderer", "teal.reporter")

card1 <- ReportCard$new()
card1$append_text("Header 2 text", "header2")
card1$append_text("A paragraph of default text")
card1$append_plot(
 ggplot(iris, aes(x = Petal.Length)) + geom_histogram()
)

card2 <- ReportCard$new()
card2$append_text("Header 2 text", "header2")
card2$append_text("A paragraph of default text")
lyt <- analyze(split_rows_by(basic_table(), "Day"), "Ozone", afun = mean)
table_res2 <- build_table(lyt, airquality)
card2$append_table(table_res2)
card2$append_rcode("2+2", echo = FALSE)

reporter <- Reporter$new()
reporter$append_cards(list(card1, card2))

yaml_l <- list(
  author = yaml_quoted("NEST"),
  title = yaml_quoted("Report"),
  date = yaml_quoted("07/04/2019"),
  output = list(html_document = list(toc = FALSE))
)

yaml_header <- md_header(as.yaml(yaml_l))
result_path <- Renderer$new()$render(reporter$get_blocks(), yaml_header)
\dontshow{\}) # examplesIf}

## ------------------------------------------------
## Method `Renderer$new`
## ------------------------------------------------

Renderer <- getFromNamespace("Renderer", "teal.reporter")
Renderer$new()


## ------------------------------------------------
## Method `Renderer$get_output_dir`
## ------------------------------------------------

Renderer <- getFromNamespace("Renderer", "teal.reporter")$new()
Renderer$get_output_dir()

}
\keyword{internal}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Renderer-new}{\code{Renderer$new()}}
\item \href{#method-Renderer-finalize}{\code{Renderer$finalize()}}
\item \href{#method-Renderer-renderRmd}{\code{Renderer$renderRmd()}}
\item \href{#method-Renderer-render}{\code{Renderer$render()}}
\item \href{#method-Renderer-get_output_dir}{\code{Renderer$get_output_dir()}}
\item \href{#method-Renderer-clone}{\code{Renderer$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Renderer-new"></a>}}
\if{latex}{\out{\hypertarget{method-Renderer-new}{}}}
\subsection{Method \code{new()}}{
Initialize a \code{Renderer} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Renderer$new()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Creates a new instance of \code{Renderer}
with a temporary directory for storing report files.
}

\subsection{Returns}{
Object of class \code{Renderer}, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{Renderer <- getFromNamespace("Renderer", "teal.reporter")
Renderer$new()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Renderer-finalize"></a>}}
\if{latex}{\out{\hypertarget{method-Renderer-finalize}{}}}
\subsection{Method \code{finalize()}}{
Finalizes a \code{Renderer} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Renderer$finalize()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Renderer-renderRmd"></a>}}
\if{latex}{\out{\hypertarget{method-Renderer-renderRmd}{}}}
\subsection{Method \code{renderRmd()}}{
Getting the \code{Rmd} text which could be easily rendered later.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Renderer$renderRmd(
  blocks,
  yaml_header,
  global_knitr = getOption("teal.reporter.global_knitr")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{blocks}}{(\code{list}) of \code{TextBlock}, \code{PictureBlock} and \code{NewpageBlock} objects.}

\item{\code{yaml_header}}{(\code{character}) an \code{rmarkdown} \code{yaml} header.}

\item{\code{global_knitr}}{(\code{list}) of \code{knitr} parameters (passed to \code{knitr::opts_chunk$set})
for customizing the rendering process.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
To access the default values for the \code{global_knitr} parameter,
use \code{getOption('teal.reporter.global_knitr')}. These defaults include:
\itemize{
\item \code{echo = TRUE}
\item \code{tidy.opts = list(width.cutoff = 60)}
\item \code{tidy = TRUE}  if \code{formatR} package is installed, \code{FALSE} otherwise
}
}

\subsection{Returns}{
Character vector constituting \code{rmarkdown} text (\code{yaml} header + body), ready to be rendered.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Renderer-render"></a>}}
\if{latex}{\out{\hypertarget{method-Renderer-render}{}}}
\subsection{Method \code{render()}}{
Renders the \code{Report} to the desired output format by compiling the \code{rmarkdown} file.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Renderer$render(
  blocks,
  yaml_header,
  global_knitr = getOption("teal.reporter.global_knitr"),
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{blocks}}{(\code{list}) of \code{TextBlock}, \code{PictureBlock} or \code{NewpageBlock} objects.}

\item{\code{yaml_header}}{(\code{character}) an \code{rmarkdown} \code{yaml} header.}

\item{\code{global_knitr}}{(\code{list}) of \code{knitr} parameters (passed to \code{knitr::opts_chunk$set})
for customizing the rendering process.}

\item{\code{...}}{\code{rmarkdown::render} arguments, \code{input} and \code{output_dir} should not be updated.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
To access the default values for the \code{global_knitr} parameter,
use \code{getOption('teal.reporter.global_knitr')}. These defaults include:
\itemize{
\item \code{echo = TRUE}
\item \code{tidy.opts = list(width.cutoff = 60)}
\item \code{tidy = TRUE}  if \code{formatR} package is installed, \code{FALSE} otherwise
}
}

\subsection{Returns}{
\code{character} path to the output.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Renderer-get_output_dir"></a>}}
\if{latex}{\out{\hypertarget{method-Renderer-get_output_dir}{}}}
\subsection{Method \code{get_output_dir()}}{
Get \code{output_dir} field.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Renderer$get_output_dir()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{character} a \code{output_dir} field path.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{Renderer <- getFromNamespace("Renderer", "teal.reporter")$new()
Renderer$get_output_dir()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Renderer-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Renderer-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Renderer$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
