% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HTMLBlock.R
\docType{class}
\name{HTMLBlock}
\alias{HTMLBlock}
\title{\code{HTMLBlock}}
\description{
Specialized \code{FileBlock} for managing HTML content in reports.
It's designed to handle various HTML content, and render the report as HTML,
however \code{htmlwidgets} objects can also be rendered to static document-ready format.
}
\examples{

## ------------------------------------------------
## Method `HTMLBlock$from_list`
## ------------------------------------------------

HTMLBlock <- getFromNamespace("HTMLBlock", "teal.reporter")
block <- HTMLBlock$new()
block$from_list(list(content = shiny::tags$div("test")))


## ------------------------------------------------
## Method `HTMLBlock$to_list`
## ------------------------------------------------

HTMLBlock <- getFromNamespace("HTMLBlock", "teal.reporter")
block <- HTMLBlock$new(shiny::tags$div("test"))
block$to_list()

}
\keyword{internal}
\section{Super class}{
\code{\link[teal.reporter:ContentBlock]{teal.reporter::ContentBlock}} -> \code{HTMLBlock}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-HTMLBlock-new}{\code{HTMLBlock$new()}}
\item \href{#method-HTMLBlock-from_list}{\code{HTMLBlock$from_list()}}
\item \href{#method-HTMLBlock-to_list}{\code{HTMLBlock$to_list()}}
\item \href{#method-HTMLBlock-clone}{\code{HTMLBlock$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="teal.reporter" data-topic="ContentBlock" data-id="get_content"><a href='../../teal.reporter/html/ContentBlock.html#method-ContentBlock-get_content'><code>teal.reporter::ContentBlock$get_content()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.reporter" data-topic="ContentBlock" data-id="set_content"><a href='../../teal.reporter/html/ContentBlock.html#method-ContentBlock-set_content'><code>teal.reporter::ContentBlock$set_content()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HTMLBlock-new"></a>}}
\if{latex}{\out{\hypertarget{method-HTMLBlock-new}{}}}
\subsection{Method \code{new()}}{
Initialize a \code{HTMLBlock} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HTMLBlock$new(content)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{content}}{An object that can be rendered as a HTML content assigned to
this \code{HTMLBlock}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Object of class \code{HTMLBlock}, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HTMLBlock-from_list"></a>}}
\if{latex}{\out{\hypertarget{method-HTMLBlock-from_list}{}}}
\subsection{Method \code{from_list()}}{
Create the \code{HTMLBlock} from a list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HTMLBlock$from_list(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{(\verb{named list}) with a single field \code{content} containing \code{shiny.tag},
\code{shiny.tag.list} or \code{htmlwidget}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{self}, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{HTMLBlock <- getFromNamespace("HTMLBlock", "teal.reporter")
block <- HTMLBlock$new()
block$from_list(list(content = shiny::tags$div("test")))

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HTMLBlock-to_list"></a>}}
\if{latex}{\out{\hypertarget{method-HTMLBlock-to_list}{}}}
\subsection{Method \code{to_list()}}{
Convert the \code{HTMLBlock} to a list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HTMLBlock$to_list()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\verb{named list} with a text and style.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{HTMLBlock <- getFromNamespace("HTMLBlock", "teal.reporter")
block <- HTMLBlock$new(shiny::tags$div("test"))
block$to_list()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HTMLBlock-clone"></a>}}
\if{latex}{\out{\hypertarget{method-HTMLBlock-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HTMLBlock$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
