% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_t_tte.R
\name{template_tte}
\alias{template_tte}
\title{Template: Time-To-Event}
\usage{
template_tte(
  dataname = "ANL",
  parentname = "ADSL",
  arm_var = "ARM",
  paramcd,
  ref_arm = NULL,
  comp_arm = NULL,
  compare_arm = FALSE,
  combine_comp_arms = FALSE,
  aval_var = "AVAL",
  cnsr_var = "CNSR",
  strata_var = NULL,
  time_points = NULL,
  time_unit_var = "AVALU",
  event_desc_var = "EVNTDESC",
  control = control_tte(),
  add_total = FALSE,
  total_label = default_total_label(),
  na_level = tern::default_na_str(),
  basic_table_args = teal.widgets::basic_table_args()
)
}
\arguments{
\item{dataname}{(\code{character})\cr analysis data used in teal module.}

\item{parentname}{(\code{character})\cr parent analysis data used in teal module, usually this refers to \code{ADSL}.}

\item{arm_var}{(\code{character})\cr variable names that can be used as \code{arm_var}.}

\item{paramcd}{(\code{character})\cr endpoint parameter value to use in the table title.}

\item{ref_arm}{(\code{character})\cr the level of reference arm in case of arm comparison.}

\item{comp_arm}{(\code{character})\cr the level of comparison arm in case of arm comparison.}

\item{compare_arm}{(\code{logical})\cr triggers the comparison between study arms.}

\item{combine_comp_arms}{(\code{logical})\cr triggers the combination of comparison arms.}

\item{aval_var}{(\code{character})\cr name of the analysis value variable.}

\item{cnsr_var}{(\code{character})\cr name of the censoring variable.}

\item{strata_var}{(\code{character})\cr names of the variables for stratified analysis.}

\item{time_points}{(\code{character})\cr time points that can be used in \code{\link[tern:survival_timepoint]{tern::surv_timepoint()}}.}

\item{time_unit_var}{(\code{character})\cr name of the variable representing time units.}

\item{event_desc_var}{(\code{character})\cr name of the variable with events description.}

\item{control}{(\code{list})\cr list of settings for the analysis. See \code{\link[=control_tte]{control_tte()}} for details.}

\item{add_total}{(\code{logical})\cr whether to include column with total number of patients.}

\item{total_label}{(\code{string})\cr string to display as total column/row label if column/row is
enabled (see \code{add_total}). Defaults to \code{"All Patients"}. To set a new default \code{total_label} to
apply in all modules, run \code{set_default_total_label("new_default")}.}

\item{na_level}{(\code{string})\cr used to replace all \code{NA} or empty values
in character or factor variables in the data. Defaults to \code{"<Missing>"}. To set a
default \code{na_level} to apply in all modules, run \code{set_default_na_str("new_default")}.}

\item{basic_table_args}{(\code{basic_table_args}) optional\cr object created by \code{\link[teal.widgets:basic_table_args]{teal.widgets::basic_table_args()}}
with settings for the module table. The argument is merged with option \code{teal.basic_table_args} and with default
module arguments (hard coded in the module body).
For more details, see the vignette: \code{vignette("custom-basic-table-arguments", package = "teal.widgets")}.}
}
\value{
a \code{list} of expressions to generate a table or plot object.
}
\description{
Creates a valid expression to generate a time-to-event analysis.
}
\seealso{
\code{\link[=control_tte]{control_tte()}}, \code{\link[=tm_t_tte]{tm_t_tte()}}
}
\keyword{internal}
