% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_g_km.R
\name{template_g_km}
\alias{template_g_km}
\title{Template: Kaplan-Meier Plot}
\usage{
template_g_km(
  dataname = "ANL",
  arm_var = "ARM",
  ref_arm = NULL,
  comp_arm = NULL,
  compare_arm = FALSE,
  combine_comp_arms = FALSE,
  aval_var = "AVAL",
  cnsr_var = "CNSR",
  xticks = NULL,
  strata_var = NULL,
  time_points = NULL,
  facet_var = "SEX",
  font_size = 11,
  conf_level = 0.95,
  conf_type = "plain",
  ties = "efron",
  xlab = "Survival time",
  time_unit_var = "AVALU",
  yval = "Survival",
  ylim = NULL,
  pval_method = "log-rank",
  annot_surv_med = TRUE,
  annot_coxph = TRUE,
  control_annot_surv_med = control_surv_med_annot(),
  control_annot_coxph = tern::control_coxph_annot(x = 0.27, y = 0.35, w = 0.3),
  legend_pos = NULL,
  rel_height_plot = 0.8,
  ci_ribbon = FALSE,
  title = "KM Plot"
)
}
\arguments{
\item{dataname}{(\code{character})\cr analysis data used in teal module.}

\item{arm_var}{(\code{character})\cr variable names that can be used as \code{arm_var}.}

\item{ref_arm}{(\code{character})\cr the level of reference arm in case of arm comparison.}

\item{comp_arm}{(\code{character})\cr the level of comparison arm in case of arm comparison.}

\item{compare_arm}{(\code{logical})\cr triggers the comparison between study arms.}

\item{combine_comp_arms}{(\code{logical})\cr triggers the combination of comparison arms.}

\item{aval_var}{(\code{character})\cr name of the analysis value variable.}

\item{cnsr_var}{(\code{character})\cr name of the censoring variable.}

\item{xticks}{(\code{numeric} or \code{NULL})\cr numeric vector of tick positions or a single number with spacing
between ticks on the x-axis. If \code{NULL} (default), \code{\link[labeling:extended]{labeling::extended()}} is used to determine
optimal tick positions on the x-axis.}

\item{strata_var}{(\code{character})\cr names of the variables for stratified analysis.}

\item{time_points}{(\code{character})\cr time points that can be used in \code{\link[tern:survival_timepoint]{tern::surv_timepoint()}}.}

\item{facet_var}{(\code{character})\cr name of the variable to use to facet the plot.}

\item{font_size}{(\code{numeric})\cr font size value.}

\item{conf_level}{(\code{numeric})\cr value for the confidence level within the range of (0, 1).}

\item{conf_type}{(\code{string})\cr confidence interval type for median survival time CI. Options are "plain" (default),
"log", "log-log".}

\item{ties}{(\code{string})\cr among \code{exact} (equivalent to \code{DISCRETE} in SAS), \code{efron} and \code{breslow},
see \code{\link[survival:coxph]{survival::coxph()}}. Note: there is no equivalent of SAS \code{EXACT} method in R.}

\item{xlab}{(\code{string})\cr x-axis label.}

\item{time_unit_var}{(\code{character})\cr name of the variable representing time units.}

\item{yval}{(\code{string})\cr type of plot, to be plotted on the y-axis. Options are \code{Survival} (default) and \code{Failure}
probability.}

\item{ylim}{(\code{numeric(2)})\cr vector containing lower and upper limits for the y-axis, respectively.
If \code{NULL} (default), the default scale range is used.}

\item{pval_method}{(\code{string})\cr the method used for estimation of p.values; \code{wald} (default) or \code{likelihood}.}

\item{annot_surv_med}{(\code{flag})\cr compute and add the annotation table on the Kaplan-Meier curve estimating the
median survival time per group.}

\item{annot_coxph}{(\code{flag})\cr whether to add the annotation table from a \code{\link[survival:coxph]{survival::coxph()}} model.}

\item{control_annot_surv_med}{(\code{list})\cr parameters to control the position and size of the annotation table added
to the plot when \code{annot_surv_med = TRUE}, specified using the \code{\link[tern:control_surv_med_annot]{control_surv_med_annot()}} function. Parameter
options are: \code{x}, \code{y}, \code{w}, \code{h}, and \code{fill}. See \code{\link[tern:control_surv_med_annot]{control_surv_med_annot()}} for details.}

\item{control_annot_coxph}{(\code{list})\cr parameters to control the position and size of the annotation table added
to the plot when \code{annot_coxph = TRUE}, specified using the \code{\link[tern:control_coxph_annot]{control_coxph_annot()}} function. Parameter
options are: \code{x}, \code{y}, \code{w}, \code{h}, \code{fill}, and \code{ref_lbls}. See \code{\link[tern:control_coxph_annot]{control_coxph_annot()}} for details.}

\item{legend_pos}{(\code{numeric(2)} or \code{NULL})\cr vector containing x- and y-coordinates, respectively, for the legend
position relative to the KM plot area. If \code{NULL} (default), the legend is positioned in the bottom right corner of
the plot, or the middle right of the plot if needed to prevent overlapping.}

\item{rel_height_plot}{(\code{proportion})\cr proportion of total figure height to allocate to the Kaplan-Meier plot.
Relative height of patients at risk table is then \code{1 - rel_height_plot}. If \code{annot_at_risk = FALSE} or
\code{as_list = TRUE}, this parameter is ignored.}

\item{ci_ribbon}{(\code{flag})\cr whether the confidence interval should be drawn around the Kaplan-Meier curve.}

\item{title}{(\code{character})\cr title of the output.}
}
\value{
a \code{list} of expressions to generate a table or plot object.
}
\description{
Creates a valid expression to generate a Kaplan-Meier plot.
}
\seealso{
\code{\link[=tm_g_km]{tm_g_km()}}
}
\keyword{internal}
