% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc2.R
\name{mc2}
\alias{mc2}
\title{Perform level 2  
multiple-concentration processing}
\usage{
mc2(ac, wr = FALSE)
}
\arguments{
\item{ac}{Integer of length 1, assay component id (acid) for processing.}

\item{wr}{Logical, whether the processed data should be written to the tcpl
database}
}
\value{
A boolean of length 1, indicating the success of the processing, or 
when 'wr' is FALSE, a list where the first element is a boolean indicating 
the success of processing and the second element is a data.table containing 
the processed data
}
\description{
\code{mc2} loads level 1 data from the tcpl 
database for the given id and performs level 2 
multiple-concentration processing. 
The processed data is then loaded into the mc2 table and 
all subsequent data is deleted with \code{\link{tcplCascade}}. See details 
for more information.

The individual processing functions are no longer exported, as it is 
typically more convenient and suggested to use the \code{\link{tcplRun}} 
wrapper function.
}
\details{
Level 2 multiple-concentration processing includes defining the
corrected value, cval, based on the correction methods listed in the
mc2_acid and mc2_methods tables.
}
\seealso{
\code{\link{Method functions}}, \code{\link{MC2_Methods}}

Other multiple-concentration: 
\code{\link{mc1}()},
\code{\link{mc3}()},
\code{\link{mc4}()},
\code{\link{mc5}()},
\code{\link{mc6}()}
}
\concept{multiple-concentration}
