% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxon_db_def.R
\name{taxon_db_def}
\alias{taxon_db_def}
\title{Taxon database definition class}
\usage{
taxon_db_def(
  name = character(),
  url = NA_character_,
  desc = NA_character_,
  id_regex = NA_character_,
  rank_levels = rep(list(NULL), length(name))
)
}
\arguments{
\item{name}{Name of the database in lower case. Inputs will be transformed to a \code{character} vector.}

\item{url}{URL of the database website. Inputs will be transformed to a \code{character} vector.}

\item{desc}{Description of the database. Inputs will be transformed to a \code{character} vector.}

\item{id_regex}{A regular expression for taxon IDs of the database. Inputs will be transformed to a \code{character} vector.}

\item{rank_levels}{Valid taxonomic ranks for the database. Should be a list of \code{numeric} vectors named by taxonomic ranks.}
}
\value{
An \code{S3} object of class \code{taxa_taxon_db_def}
}
\description{
Used to store information on taxonomic databases that is used to validate information in other classes.
}
\keyword{internal}
