% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluation.R
\name{summarize_cv_survdnn}
\alias{summarize_cv_survdnn}
\title{Summarize Cross-Validation Results from survdnn}
\usage{
summarize_cv_survdnn(cv_results, by_time = TRUE, conf_level = 0.95)
}
\arguments{
\item{cv_results}{A tibble returned by [cv_survdnn()].}

\item{by_time}{Logical. Whether to stratify results by `time` (if present).}

\item{conf_level}{Confidence level for the intervals (default: 0.95).}
}
\value{
A tibble summarizing mean, sd, and confidence bounds per metric (and per time if applicable).
}
\description{
Computes mean, standard deviation, and confidence intervals for metrics from cross-validation.
}
\examples{
library(survival)
data(veteran)
res <- cv_survdnn(
  Surv(time, status) ~ age + karno + celltype,
  data = veteran,
  times = c(30, 90, 180, 270),
  metrics = c("cindex", "ibs"),
  folds = 3,
  .seed = 42,
  hidden = c(16, 8),
  epochs = 5
)
summarize_cv_survdnn(res)
}
