% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/subclu.R
\name{SubClu}
\alias{SubClu}
\title{The SubClu Algorithm for Subspace Clustering}
\usage{
SubClu(data, epsilon = 4, minSupport = 4)
}
\arguments{
\item{data}{A Matrix of input data.}

\item{epsilon}{size of environment parameter for DBSCAN}

\item{minSupport}{minimum number of points parameter for DBSCAN}
}
\description{
The SubClu Algorithm follows a bottom-up framework, in which one-dimensional
clusters are generated with DBSCAN and then each cluster is expanded one
dimension at a time into a dimension that is known to have a cluster that only
differs in one dimension from this cluster. This expansion is done using
DBSCAN with the same parameters that were used for the original DBSCAN that
produced the clusters.
}
\examples{
data("subspace_dataset")
SubClu(subspace_dataset,epsilon=1,minSupport=5)
}
\references{
Karin Kailing, Hans-Peter Kriegel and Peer Kröger
 \emph{Density-Connected Subspace Clustering for High-Dimensional Data}
}
\seealso{
Other subspace.clustering.algorithms: \code{\link{CLIQUE}};
  \code{\link{FIRES}}; \code{\link{P3C}};
  \code{\link{ProClus}}
}

