/*
 * Decompiled with CFR 0.152.
 */
package dag;

import dag.Dag;
import dag.DagLevel;
import vcf.Markers;

public final class ImmutableDag
implements Dag {
    private final Markers markers;
    private final long nNodes;
    private final long nEdges;
    private final int maxNodes;
    private final int maxEdges;
    private final DagLevel[] dagLevels;
    private final double[] posArray;

    public ImmutableDag(Markers markers, DagLevel[] dagLevelArray) {
        if (dagLevelArray.length == 0) {
            throw new IllegalArgumentException("levels.length==0");
        }
        if (dagLevelArray[0].nParentNodes() != 1) {
            throw new IllegalArgumentException("levels[0].nParentNodes()!=1");
        }
        int n = 1;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        double[] dArray = new double[dagLevelArray.length];
        for (int i = 0; i < dagLevelArray.length; ++i) {
            if (i > 0 && dagLevelArray[i - 1].nChildNodes() != dagLevelArray[i].nParentNodes()) {
                throw new IllegalArgumentException("inconsistent levels");
            }
            n += dagLevelArray[i].nChildNodes();
            n2 += dagLevelArray[i].nEdges();
            if (dagLevelArray[i].nChildNodes() > n3) {
                n3 = dagLevelArray[i].nChildNodes();
            }
            if (dagLevelArray[i].nEdges() > n4) {
                n4 = dagLevelArray[i].nEdges();
            }
            double d = ImmutableDag.minusLog10CondEdgeProb(dagLevelArray[i]);
            dArray[i] = i == 0 ? d : dArray[i - 1] + d;
        }
        this.dagLevels = (DagLevel[])dagLevelArray.clone();
        this.posArray = dArray;
        this.markers = markers;
        this.nNodes = n;
        this.nEdges = n2;
        this.maxEdges = n4;
        this.maxNodes = n3;
    }

    private static double minusLog10CondEdgeProb(DagLevel dagLevel) {
        float f = 0.0f;
        int n = dagLevel.nEdges();
        for (int i = 0; i < n; ++i) {
            f += dagLevel.edgeProb(i) * dagLevel.condEdgeProb(i);
        }
        double d = -Math.log10(f);
        return d < 0.0 ? 0.0 : d;
    }

    @Override
    public int nEdges(int n) {
        return this.dagLevels[n].nEdges();
    }

    @Override
    public int nParentNodes(int n) {
        return this.dagLevels[n].nParentNodes();
    }

    @Override
    public int nChildNodes(int n) {
        return this.dagLevels[n].nChildNodes();
    }

    @Override
    public int parentNode(int n, int n2) {
        return this.dagLevels[n].parentNode(n2);
    }

    @Override
    public int childNode(int n, int n2) {
        return this.dagLevels[n].childNode(n2);
    }

    @Override
    public int symbol(int n, int n2) {
        return this.dagLevels[n].symbol(n2);
    }

    @Override
    public float edgeWeight(int n, int n2) {
        return this.dagLevels[n].edgeWeight(n2);
    }

    @Override
    public float parentWeight(int n, int n2) {
        return this.dagLevels[n].parentWeight(n2);
    }

    @Override
    public float condEdgeProb(int n, int n2) {
        return this.dagLevels[n].condEdgeProb(n2);
    }

    @Override
    public float edgeProb(int n, int n2) {
        return this.dagLevels[n].edgeProb(n2);
    }

    @Override
    public float parentProb(int n, int n2) {
        return this.dagLevels[n].parentProb(n2);
    }

    @Override
    public int nLevels() {
        return this.dagLevels.length;
    }

    @Override
    public Markers markers() {
        return this.markers;
    }

    @Override
    public long nNodes() {
        return this.nNodes;
    }

    @Override
    public long nEdges() {
        return this.nEdges;
    }

    @Override
    public int maxNodes() {
        return this.maxNodes;
    }

    @Override
    public int maxEdges() {
        return this.maxEdges;
    }

    @Override
    public int nOutEdges(int n, int n2) {
        return this.dagLevels[n].nOutEdges(n2);
    }

    @Override
    public int outEdge(int n, int n2, int n3) {
        return this.dagLevels[n].outEdge(n2, n3);
    }

    @Override
    public int outEdgeBySymbol(int n, int n2, int n3) {
        return this.dagLevels[n].outEdgeBySymbol(n2, n3);
    }

    @Override
    public int nInEdges(int n, int n2) {
        return this.dagLevels[n].nInEdges(n2);
    }

    @Override
    public int inEdge(int n, int n2, int n3) {
        return this.dagLevels[n].inEdge(n2, n3);
    }

    @Override
    public boolean isChildOf(int n, int n2, int n3) {
        int n4;
        int n5 = this.dagLevels[n + 1].parentNode(n3);
        return n5 == (n4 = this.dagLevels[n].childNode(n2));
    }

    @Override
    public double[] posArray() {
        return (double[])this.posArray.clone();
    }

    @Override
    public String toString(int n, int n2) {
        String string = System.getProperty("line.separator");
        StringBuilder stringBuilder = new StringBuilder(1000);
        for (int i = n; i < n2; ++i) {
            stringBuilder.append("level=");
            stringBuilder.append(i);
            stringBuilder.append(": ");
            stringBuilder.append(this.dagLevels[i]);
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        String string = System.getProperty("line.separator");
        StringBuilder stringBuilder = new StringBuilder(2000);
        stringBuilder.append("[Dag: nMarkers=");
        stringBuilder.append(this.dagLevels.length);
        stringBuilder.append("  nodes=");
        stringBuilder.append(this.nNodes);
        stringBuilder.append("  edges=");
        stringBuilder.append(this.nEdges);
        stringBuilder.append("  maxNodes=");
        stringBuilder.append(this.maxNodes);
        stringBuilder.append("  maxEdges=");
        stringBuilder.append(this.maxEdges);
        stringBuilder.append(string);
        for (int i = 0; i < this.dagLevels.length; ++i) {
            stringBuilder.append(string);
            stringBuilder.append("level=");
            stringBuilder.append(i);
            stringBuilder.append(": ");
            stringBuilder.append(this.dagLevels[i]);
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }
}

