% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparsePCAloc_methods.R
\name{plot_score_distances}
\alias{plot_score_distances}
\title{Distance-distance plot of scores of PCA}
\usage{
plot_score_distances(X, PC, groups, ssMRCD, k, ...)
}
\arguments{
\item{X}{data matrix.}

\item{PC}{loadings from PCA.}

\item{groups}{vector containing group assignments.}

\item{ssMRCD}{ssMRCD object.}

\item{k}{integer of how many components should be used.}

\item{...}{other input arguments, see details.}
}
\value{
Returns distance-distance plot of orthogonal and score distance.
}
\description{
Distance-distance plot of scores of PCA
}
\details{
Additional parameters that can be given to the function are: \tabular{ll}{
   \code{shape} \tab point shape  \cr
   \tab \cr
   \code{size} \tab point size \cr
   \tab \cr
   \code{alpha} \tab transparency  \cr
   \tab \cr
}
}
\examples{
# set seed
set.seed(236)

data = matrix(rnorm(2000), ncol = 4)
groups = sample(1:10, 500, replace = TRUE)
W = time_weights(N = 10, c(3,2,1))

# calculate covariance matrices
covs = ssMRCD(data, groups = groups, weights = W, lambda = 0.3)

# sparse PCA
pca = sparsePCAloc(eta = 0.3, gamma = 0.7, cor = FALSE, COVS = covs$MRCDcov,
             n_max = 1000, increase_rho = list(TRUE, 50, 1), trace = FALSE)

# plot score distances
plot_score_distances(PC = pca$PC,
                     groups = groups,
                     X = data,
                     ssMRCD = covs,
                     k = 2,
                     alpha = 0.4,
                     shape = 16,
                     size = 2)
}
