% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use-rates.R
\name{application_rate_g_per_ha}
\alias{application_rate_g_per_ha}
\title{Calculate application rates for active ingredients}
\usage{
application_rate_g_per_ha(
  product_uses,
  aggregation = c("max", "mean", "min"),
  dosage_units = c("percent_ww", "percent_vv", "state_of_matter"),
  skip_l_per_ha_without_g_per_L = TRUE,
  fix_l_per_ha = TRUE
)
}
\arguments{
\item{product_uses}{A tibble containing the columns 'pNbr', 'use_nr',
'application_area_de', 'min_dosage', 'max_dosage', 'min_rate', 'max_rate',
from the 'uses' table in a \link{srppp_dm} object, as well as the columns
'percent' and 'g_per_L' from the 'ingredients' table in a \link{srppp_dm} object.}

\item{aggregation}{How to represent a range if present, e.g. "max" (default)
or "mean".}

\item{dosage_units}{If no units are given, or units are "\%", then the applied
amount in g/ha is calculated using a reference application volume and the
dosage. As the dosage units are not explicitly given, we can specify our
assumptions about these using this argument (currently not implemented, i.e.
specifying the argument has no effect).}

\item{skip_l_per_ha_without_g_per_L}{Per default, uses where the use rate
has units of l/ha are skipped, if there is not product concentration
in g/L. This was also done in the 2023 indicator project.}

\item{fix_l_per_ha}{During the review of the 2023 indicator
project calculations, a number of cases were identified where the unit
l/ha specifies a water volume, and not a product volume. If TRUE (default),
these cases are corrected, if FALSE, these cases are discarded.}
}
\value{
A tibble containing one additional column 'rate_g_per_ha'
}
\description{
An application rate in g active substance/ha is calculated from information
on dosage (product concentration in the application solution), application volume,
or directly from the product application rate. This is complicated by the fact
that a rate ("expenditure" in the XML file) with units l/ha can refer
to the application solution or to the liquid product.
}
\details{
In some cases (currently one), external information was found, indicating
that the "expenditure" is an application volume \link{l_per_ha_is_water_volume}.
}
\note{
A reference application volume is used if there is no 'expenditure'.
It is selected only based on the product application area. This is not correct
if hops ('Hopfen') is the culture, as it has a unique reference application
volume of 3000 L/ha.

Applications to hops were excluded for calculating mean use rates in the
indicator project (Korkaric 2023), arguing that it is not grown in large
areas in Switzerland.
}
\examples{
\donttest{
library(srppp)
library(dplyr, warn.conflicts = FALSE)
library(dm, warn.conflicts = FALSE)
sr <- srppp_dm()

product_uses_with_ingredients <- sr$substances |>
  filter(substance_de \%in\% c("Halauxifen-methyl", "Kupfer (als Kalkpr\u00E4parat)")) |>
  left_join(sr$ingredients, by = "pk") |>
  left_join(sr$uses, by = "pNbr") |>
  left_join(sr$products, by = "pNbr") |>
  select(pNbr, name, use_nr,
    min_dosage, max_dosage, min_rate, max_rate, units_de,
    application_area_de,
    substance_de, percent, g_per_L)

application_rate_g_per_ha(product_uses_with_ingredients) |>
  filter(name \%in\% c("Cerelex", "Pixxaro EC", "Bordeaux S")) |>
  select(ai = substance_de, app_area = application_area_de,
    min_d = min_dosage,  max_d = max_dosage,
    min_r = min_rate, max_r = max_rate,
    units_de, rate = rate_g_per_ha) |>
  print(n = Inf)
}
}
