% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features-hockey.R
\name{hockey_nodzone_faceoff_spot_stripe}
\alias{hockey_nodzone_faceoff_spot_stripe}
\title{The non-centered faceoff spots are located in the neutral, offensive and
defensive zones of the ice, with one on each side of the x-axis when viewing
the rink in TV view. These spots differ from the center faceoff spot because
they have a larger diameter, differ in color, and have a colored stripe that
runs through its center.}
\usage{
hockey_nodzone_faceoff_spot_stripe(
  feature_radius = 0,
  feature_thickness = 0,
  gap_width = 0
)
}
\arguments{
\item{feature_radius}{The outer radius of the non-centered faceoff spot}

\item{feature_thickness}{The thickness of the non-centered faceoff spot ring}

\item{gap_width}{The width of the gap from the inner edge of the non-centered
faceoff spot ring to the outer edge of the stripe}
}
\value{
A data frame containing the bounding coordinates of the non-centered
faceoff spot's stripe
}
\description{
This function is responsible for creating the inner stripe, not the colored
outer ring around it. Please see \code{\link[=hockey_nodzone_faceoff_spot_ring]{hockey_nodzone_faceoff_spot_ring()}} for
more information on it
}
\details{
The non-centered faceoff spots are where faceoffs are taken after an icing
call or to start a powerplay. They differ from the center ice faceoff spot in
size, color, and form. For the faceoff spot's stripe, the 'feature_thickness'
parameter should be the thickness of the outer ring, which is
'minor_line_thickness'
}
\keyword{internal}
