% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels.R, R/labels_glm.R
\name{labels.spmodel}
\alias{labels.spmodel}
\alias{labels.splm}
\alias{labels.spautor}
\alias{labels.spglm}
\alias{labels.spgautor}
\title{Find labels from object}
\usage{
\method{labels}{splm}(object, ...)

\method{labels}{spautor}(object, ...)

\method{labels}{spglm}(object, ...)

\method{labels}{spgautor}(object, ...)
}
\arguments{
\item{object}{A fitted model object from \code{\link[=splm]{splm()}}, \code{\link[=spautor]{spautor()}}, \code{\link[=spglm]{spglm()}}, or \code{\link[=spgautor]{spgautor()}}.}

\item{...}{Other arguments. Not used (needed for generic consistency).}
}
\value{
A character vector containing the terms used for the fixed effects
from a fitted model object.
}
\description{
Find a suitable set of labels from a fitted model object.
}
\examples{
spmod <- splm(z ~ water + tarp,
  data = caribou,
  spcov_type = "exponential", xcoord = x, ycoord = y
)
labels(spmod)
}
