% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/harmonics.R
\name{angles_to_sphere}
\alias{angles_to_sphere}
\alias{sphere_to_angles}
\title{Conversion between angular and Cartesian coordinates of the
(hyper)sphere}
\usage{
angles_to_sphere(theta)

sphere_to_angles(x)
}
\arguments{
\item{theta}{matrix of size \code{c(n, p - 1)} with the angles.}

\item{x}{matrix of size \code{c(n, p)} with the Cartesian coordinates.
Assumed to be of unit norm by rows.}
}
\value{
For \code{angles_to_sphere}, the matrix \code{x}. For
\code{sphere_to_angles}, the matrix \code{theta}.
}
\description{
Transforms the angles \eqn{(\theta_1,\ldots,\theta_{p-1})'} in
\eqn{[0,\pi)^{p-2}\times[-\pi,\pi)} into the Cartesian coordinates
\deqn{(\cos(x_1),\sin(x_1)\cos(x_2),\ldots,
\sin(x_1)\cdots\sin(x_{p-2})\cos(x_{p-1}),
\sin(x_1)\cdots\sin(x_{p-2})\sin(x_{p-1}))'}
of \eqn{S^{p-1}}, and vice versa.
}
\examples{
# Check changes of coordinates
sphere_to_angles(angles_to_sphere(c(pi / 2, 0, pi)))
sphere_to_angles(angles_to_sphere(rbind(c(pi / 2, 0, pi), c(pi, pi / 2, 0))))
angles_to_sphere(sphere_to_angles(c(0, sqrt(0.5), sqrt(0.1), sqrt(0.4))))
angles_to_sphere(sphere_to_angles(
  rbind(c(0, sqrt(0.5), sqrt(0.1), sqrt(0.4)),
        c(0, sqrt(0.5), sqrt(0.5), 0),
        c(0, 1, 0, 0),
        c(0, 0, 0, -1),
        c(0, 0, 1, 0))))

# Circle
sphere_to_angles(angles_to_sphere(0))
sphere_to_angles(angles_to_sphere(cbind(0:3)))
angles_to_sphere(cbind(sphere_to_angles(rbind(c(0, 1), c(1, 0)))))
angles_to_sphere(cbind(sphere_to_angles(rbind(c(0, 1)))))
}
