% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmrs.R
\name{mrs_data2bids}
\alias{mrs_data2bids}
\title{Create a BIDS file structure from a vector of MRS data paths or list of
mrs_data objects.}
\usage{
mrs_data2bids(
  mrs_data,
  output_dir,
  suffix = NULL,
  sub = NULL,
  ses = NULL,
  task = NULL,
  acq = NULL,
  nuc = NULL,
  voi = NULL,
  rec = NULL,
  run = NULL,
  echo = NULL,
  inv = NULL,
  skip_existing = TRUE
)
}
\arguments{
\item{mrs_data}{vector of MRS data paths or list of mrs_data objects.}

\item{output_dir}{the base directory to create the BIDS structure.}

\item{suffix}{optional vector of file suffixes. Default behaviour is to
automatically determine these from the input data, however it is recommended
that they are specified to allow more efficient skipping of existing data.}

\item{sub}{optional vector of subject labels. If not specified, these will be
automatically generated as a series of increasing zero-padded integer values
corresponding to the mrs_data input indices.}

\item{ses}{optional vector of session labels.}

\item{task}{optional vector of task labels.}

\item{acq}{optional vector of acquisition labels.}

\item{nuc}{optional vector of nucleus labels.}

\item{voi}{optional vector of volume of interest labels.}

\item{rec}{optional vector of reconstruction labels.}

\item{run}{optional vector of run indices.}

\item{echo}{optional vector of echo time indices.}

\item{inv}{optional vector of inversion indices.}

\item{skip_existing}{skip any data files that have already been converted.
Defaults to TRUE, set to FALSE to force an overwrite of any existing data
files.}
}
\description{
Create a BIDS file structure from a vector of MRS data paths or list of
mrs_data objects.
}
