% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surfaceplot.R
\name{surfaceplot}
\alias{surfaceplot}
\title{Make a surface plot}
\usage{
surfaceplot(tab, coords_name, var_name, h = 8, col.pal, mark_points = FALSE)
}
\arguments{
\item{tab}{a data-frame containing spatial co-ordinates and the variable to
plot}

\item{coords_name}{name of the two columns that contains the co-ordinates of
the points}

\item{var_name}{name of the column containing the variable to be plotted}

\item{h}{integer; (optional) controls smoothness of the spatial interpolation
as appearing in the \code{\link[MBA:mba.surf]{MBA::mba.surf()}} function. Default is 8.}

\item{col.pal}{Optional; color palette, preferably divergent, use
\code{colorRampPalette} function from \code{grDevices}. Default is 'RdYlBu'.}

\item{mark_points}{Logical; if \code{TRUE}, the input points are marked.
Default is \code{FALSE}.}
}
\value{
a \code{ggplot} object containing the surface plot
}
\description{
Make a surface plot
}
\examples{
data(simGaussian)
plot1 <- surfaceplot(simGaussian, coords_name = c("s1", "s2"),
                     var_name = "z_true")
plot1

# try your favourite color palette
col.br <- colorRampPalette(c("blue", "white", "red"))
col.br.pal <- col.br(100)
plot2 <- surfaceplot(simGaussian, coords_name = c("s1", "s2"),
                     var_name = "z_true", col.pal = col.br.pal)
plot2
}
\author{
Soumyakanti Pan \href{mailto:span18@ucla.edu}{span18@ucla.edu},\cr
Sudipto Banerjee \href{mailto:sudipto@ucla.edu}{sudipto@ucla.edu}
}
