% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bandwidth_selection_cv_tnkde_sf.R
\name{tnkde_worker_bw_sel}
\alias{tnkde_worker_bw_sel}
\title{Worker function fo Bandwidth selection by likelihood cross validation for temporal NKDE}
\usage{
tnkde_worker_bw_sel(
  lines,
  quad_events,
  events_loc,
  events,
  w,
  kernel_name,
  bws_net,
  bws_time,
  method,
  div,
  digits,
  tol,
  sparse,
  max_depth,
  verbose = FALSE,
  cvl = FALSE
)
}
\arguments{
\item{lines}{A feature collection of linestrings representing the underlying network}

\item{quad_events}{a feature collection of points indicating for which events the densities must be calculated}

\item{events_loc}{A feature collection of points representing the location of the events}

\item{events}{A feature collection of points representing the events. Multiple events can share
the same location. They are linked by the goid column}

\item{w}{A numeric array with the weight of the events for each pair of bandwidth}

\item{kernel_name}{The name of the kernel to use (string)}

\item{bws_net}{A numeric vector with the network bandwidths. Could also be an
array if an adaptive bandwidth is calculated.}

\item{bws_time}{A numeric vector with the time bandwidths. Could also be an
array if an adaptive bandwidth is calculated.}

\item{method}{The type of NKDE to use (string)}

\item{div}{The type of divisor (not used currently)}

\item{digits}{The number of digits to retain from the spatial coordinates. It
ensures that topology is good when building the network. Default is 3. Too high a
precision (high number of digits) might break some connections}

\item{tol}{A float indicating the minimum distance between the events and the
lines' extremities when adding the point to the network. When points are
closer, they are added at the extremity of the lines.}

\item{sparse}{A Boolean indicating if sparse or regular matrices should be
used by the Rcpp functions. These matrices are used to store edge indices
between two nodes in a graph. Regular matrices are faster, but require more
memory, in particular with multiprocessing. Sparse matrices are slower (a
bit), but require much less memory.}

\item{max_depth}{The maximum depth of recursion}

\item{verbose}{A boolean}

\item{cvl}{A boolean indicating if the cvl method (TRUE) or the loo (FALSE) method must be used}
}
\value{
An array with the CV score for each pair of bandiwdths (rows and lines) for each event (slices)
}
\description{
Calculate for multiple network and time bandwidths the cross validation likelihood to
select an appropriate bandwidth in a data-driven approach (INTERNAL)
}
\examples{
# no example provided, this is an internal function
}
