% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_functions_sf.R
\name{build_graph_directed}
\alias{build_graph_directed}
\title{Directed network generation}
\usage{
build_graph_directed(lines, digits, line_weight, direction, attrs = FALSE)
}
\arguments{
\item{lines}{A feature collection of linestrings}

\item{digits}{The number of digits to keep from the coordinates}

\item{line_weight}{The name of the column giving the weight of the lines}

\item{direction}{A column name indicating authorized travelling direction on
lines. if NULL, then all lines can be used in both directions. Must be the
name of a column otherwise. The values of the column must be "FT" (From -
To), "TF" (To - From) or "Both"}

\item{attrs}{A boolean indicating if the original lines' attributes should be
stored in the final object}
}
\value{
A list containing the following elements:
\itemize{
\item graph: an igraph object;
\item linelist: the dataframe used to build the graph;
\item lines: the original feature collection of lines;
\item spvertices: a feature collection of points representing the vertices
of the graph;
\item digits : the number of digits kept for the coordinates.
}
}
\description{
Generate a directed igraph object from a feature collection of linestrings
}
\details{
This function can be used to generate a directed graph object (igraph
object). It uses the coordinates of the linestrings extremities to create
the nodes of the graph. This is why the number of digits in the coordinates
is important. Too high precision (high number of digits) might break some
connections. The column used to indicate directions can only have the
following values: "FT" (From-To), "TF" (To-From) and "Both".
}
\examples{
\donttest{
data(mtl_network)
mtl_network$length <- as.numeric(sf::st_length(mtl_network))
mtl_network$direction <- "Both"
mtl_network[6, "direction"] <- "TF"
mtl_network_directed <- lines_direction(mtl_network, "direction")
graph_result <- build_graph_directed(lines = mtl_network_directed,
        digits = 2,
        line_weight = "length",
        direction = "direction",
        attrs = TRUE)
}
}
