% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiview.R
\name{multiview}
\alias{multiview}
\alias{multiview,sf-method}
\alias{multiview,SpatRaster-method}
\title{multiview embedding forecast}
\usage{
\S4method{multiview}{sf}(
  data,
  column,
  target,
  nvar,
  lib = NULL,
  pred = NULL,
  E = 3,
  tau = 1,
  k = E + 2,
  nb = NULL,
  top = NULL,
  threads = detectThreads(),
  detrend = TRUE
)

\S4method{multiview}{SpatRaster}(
  data,
  column,
  target,
  nvar,
  lib = NULL,
  pred = NULL,
  E = 3,
  tau = 1,
  k = E + 2,
  top = NULL,
  threads = detectThreads(),
  detrend = TRUE
)
}
\arguments{
\item{data}{observation data.}

\item{column}{name of library variable.}

\item{target}{name of target variable.}

\item{nvar}{number of variable combinations.}

\item{lib}{(optional) libraries indices.}

\item{pred}{(optional) predictions indices.}

\item{E}{(optional) embedding dimensions.}

\item{tau}{(optional) step of spatial lags.}

\item{k}{(optional) number of nearest neighbors used.}

\item{nb}{(optional) neighbours list.}

\item{top}{(optional) number of reconstructions used in MVE forecast.}

\item{threads}{(optional) number of threads to use.}

\item{detrend}{(optional) whether to remove the linear trend.}
}
\value{
A vector (when input is sf object) or matrix
}
\description{
multiview embedding forecast
}
\examples{
columbus = sf::read_sf(system.file("case/columbus.gpkg", package="spEDM"))
\donttest{
multiview(columbus,
          column = c("inc","crime","open","plumb","discbd"),
          target = "hoval", nvar = 3)
}
}
\references{
Ye H., and G. Sugihara, 2016. Information leverage in interconnected ecosystems: Overcoming the curse of dimensionality. Science 353:922-925.
}
